/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.listener.impl;

import java.io.Serializable;
import org.hibernate.LockMode;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.ogm.entityentry.impl.OgmEntityEntryState;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class OgmDefaultSaveOrUpdateEventListener
extends DefaultSaveOrUpdateEventListener {
    protected Serializable performSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        OgmEntityEntryState ogmEntityState;
        Serializable id = key == null ? null : key.getIdentifier();
        boolean inTxn = source.getTransactionCoordinator().isTransactionInProgress();
        boolean shouldDelayIdentityInserts = !inTxn && !requiresImmediateIdAccess;
        EntityEntry original = source.getPersistenceContext().addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false, false);
        this.cascadeBeforeSave(source, persister, entity, anything);
        Object[] values = persister.getPropertyValuesToInsert(entity, this.getMergeMap(anything), (SessionImplementor)source);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, (SessionImplementor)source);
        if (persister.hasCollections()) {
            boolean bl = substitute = substitute || this.visitCollectionsBeforeSave(entity, id, values, types, source);
        }
        if (substitute) {
            persister.setPropertyValues(entity, values);
        }
        TypeHelper.deepCopy((Object[])values, (Type[])types, (boolean[])persister.getPropertyUpdateability(), (Object[])values, (SessionImplementor)source);
        AbstractEntityInsertAction insert = this.addInsertAction(values, id, entity, persister, useIdentityColumn, source, shouldDelayIdentityInserts);
        this.cascadeAfterSave(source, persister, entity, anything);
        if (useIdentityColumn && insert.isEarlyInsert()) {
            if (!EntityIdentityInsertAction.class.isInstance(insert)) {
                throw new IllegalStateException("Insert should be using an identity column, but action is of unexpected type: " + insert.getClass().getName());
            }
            id = ((EntityIdentityInsertAction)insert).getGeneratedId();
            insert.handleNaturalIdPostSaveNotifications(id);
        }
        this.markInterceptorDirty(entity, persister, source);
        EntityEntry newEntry = source.getPersistenceContext().getEntry(entity);
        if (newEntry != original && (ogmEntityState = (OgmEntityEntryState)newEntry.getExtraState(OgmEntityEntryState.class)) == null) {
            newEntry.addExtraState(original.getExtraState(OgmEntityEntryState.class));
        }
        return id;
    }

    private AbstractEntityInsertAction addInsertAction(Object[] values, Serializable id, Object entity, EntityPersister persister, boolean useIdentityColumn, EventSource source, boolean shouldDelayIdentityInserts) {
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values, entity, persister, this.isVersionIncrementDisabled(), (SessionImplementor)source, shouldDelayIdentityInserts);
            source.getActionQueue().addAction(insert);
            return insert;
        }
        Object version = Versioning.getVersion((Object[])values, (EntityPersister)persister);
        EntityInsertAction insert = new EntityInsertAction(id, values, entity, version, persister, this.isVersionIncrementDisabled(), (SessionImplementor)source);
        source.getActionQueue().addAction(insert);
        return insert;
    }

    private void markInterceptorDirty(Object entity, EntityPersister persister, EventSource source) {
        if (persister.getInstrumentationMetadata().isInstrumented()) {
            FieldInterceptor interceptor = persister.getInstrumentationMetadata().injectInterceptor(entity, persister.getEntityName(), null, (SessionImplementor)source);
            interceptor.dirty();
        }
    }
}

