/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.source.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.options.container.impl.OptionsContainer;
import org.hibernate.ogm.options.container.impl.OptionsContainerBuilder;
import org.hibernate.ogm.options.navigation.impl.PropertyKey;
import org.hibernate.ogm.options.navigation.source.impl.OptionValueSource;
import org.hibernate.ogm.options.spi.AnnotationConverter;
import org.hibernate.ogm.options.spi.MappingOption;
import org.hibernate.ogm.options.spi.OptionValuePair;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.ReflectionHelper;

public class AnnotationOptionValueSource
implements OptionValueSource {
    private static final Log log = LoggerFactory.make();

    @Override
    public OptionsContainer getGlobalOptions() {
        return OptionsContainer.EMPTY;
    }

    @Override
    public OptionsContainer getEntityOptions(Class<?> entityType) {
        OptionsContainerBuilder options = this.convertOptionAnnotations(entityType.getAnnotations());
        return options != null ? options.build() : OptionsContainer.EMPTY;
    }

    @Override
    public OptionsContainer getPropertyOptions(Class<?> entityType, String propertyName) {
        OptionsContainerBuilder options = this.getPropertyOptions(entityType).get(new PropertyKey(entityType, propertyName));
        return options != null ? options.build() : OptionsContainer.EMPTY;
    }

    private Map<PropertyKey, OptionsContainerBuilder> getPropertyOptions(Class<?> entityClass) {
        HashMap<PropertyKey, OptionsContainerBuilder> optionsByProperty = new HashMap<PropertyKey, OptionsContainerBuilder>();
        for (Method method : entityClass.getMethods()) {
            OptionsContainerBuilder optionsOfProperty;
            String propertyName = ReflectionHelper.getPropertyName(method);
            if (propertyName == null || (optionsOfProperty = this.convertOptionAnnotations(method.getAnnotations())) == null) continue;
            optionsByProperty.put(new PropertyKey(entityClass, propertyName), optionsOfProperty);
        }
        for (AccessibleObject accessibleObject : entityClass.getDeclaredFields()) {
            PropertyKey key = new PropertyKey(entityClass, ((Field)accessibleObject).getName());
            OptionsContainerBuilder optionsOfField = this.convertOptionAnnotations(accessibleObject.getAnnotations());
            if (optionsOfField == null) continue;
            OptionsContainerBuilder optionsOfProperty = (OptionsContainerBuilder)optionsByProperty.get(key);
            if (optionsOfProperty != null) {
                optionsOfProperty.addAll(optionsOfField);
                continue;
            }
            optionsByProperty.put(key, optionsOfField);
        }
        return optionsByProperty;
    }

    private OptionsContainerBuilder convertOptionAnnotations(Annotation[] annotations) {
        OptionsContainerBuilder builder = null;
        for (Annotation annotation : annotations) {
            builder = this.processAnnotation(builder, annotation);
        }
        return builder;
    }

    private <A extends Annotation> OptionsContainerBuilder processAnnotation(OptionsContainerBuilder builder, A annotation) {
        AnnotationConverter<A> converter = this.getConverter(annotation);
        if (converter != null) {
            if (builder == null) {
                builder = new OptionsContainerBuilder();
            }
            this.add(builder, converter.convert(annotation));
        }
        return builder;
    }

    private <A extends Annotation> AnnotationConverter<A> getConverter(Annotation annotation) {
        MappingOption mappingOption = annotation.annotationType().getAnnotation(MappingOption.class);
        Class<AnnotationConverter<?>> converterClass = mappingOption != null ? mappingOption.value() : null;
        try {
            return converterClass != null ? converterClass.newInstance() : null;
        }
        catch (Exception e) {
            throw log.cannotConvertAnnotation(converterClass, e);
        }
    }

    private <V> void add(OptionsContainerBuilder builder, OptionValuePair<V> optionValue) {
        builder.add(optionValue.getOption(), optionValue.getValue());
    }
}

