/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex.impl;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.massindex.impl.BatchIndexingWorkspace;
import org.hibernate.ogm.massindex.impl.Executors;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.SearchIntegrator;

public class BatchCoordinator
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] rootEntities;
    private final ExtendedSearchIntegrator searchFactoryImplementor;
    private final SessionFactoryImplementor sessionFactory;
    private final int typesToIndexInParallel;
    private final CacheMode cacheMode;
    private final boolean optimizeAtEnd;
    private final boolean purgeAtStart;
    private final boolean optimizeAfterPurge;
    private final CountDownLatch endAllSignal;
    private final MassIndexerProgressMonitor monitor;
    private final ErrorHandler errorHandler;
    private final GridDialect gridDialect;

    public BatchCoordinator(GridDialect gridDialect, Set<Class<?>> rootEntities, ExtendedSearchIntegrator searchFactoryImplementor, SessionFactoryImplementor sessionFactory, int typesToIndexInParallel, CacheMode cacheMode, boolean optimizeAtEnd, boolean purgeAtStart, boolean optimizeAfterPurge, MassIndexerProgressMonitor monitor) {
        this.gridDialect = gridDialect;
        this.rootEntities = rootEntities.toArray(new Class[rootEntities.size()]);
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.sessionFactory = sessionFactory;
        this.typesToIndexInParallel = typesToIndexInParallel;
        this.cacheMode = cacheMode;
        this.optimizeAtEnd = optimizeAtEnd;
        this.purgeAtStart = purgeAtStart;
        this.optimizeAfterPurge = optimizeAfterPurge;
        this.monitor = monitor;
        this.endAllSignal = new CountDownLatch(rootEntities.size());
        this.errorHandler = searchFactoryImplementor.getErrorHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BatchBackend backend = this.searchFactoryImplementor.makeBatchBackend(this.monitor);
            try {
                this.beforeBatch(backend);
                this.doBatchWork(backend);
                this.afterBatch(backend);
            }
            catch (InterruptedException e) {
                log.interruptedBatchIndexing();
                Thread.currentThread().interrupt();
            }
            finally {
                this.monitor.indexingCompleted();
            }
        }
        catch (RuntimeException re) {
            this.errorHandler.handleException("ERROR", (Throwable)re);
        }
    }

    private void doBatchWork(BatchBackend backend) throws InterruptedException {
        ThreadPoolExecutor executor = Executors.newFixedThreadPool(this.typesToIndexInParallel, "BatchIndexingWorkspace");
        for (Class<?> type : this.rootEntities) {
            executor.execute(new BatchIndexingWorkspace(this.gridDialect, (SearchIntegrator)this.searchFactoryImplementor, this.sessionFactory, type, this.cacheMode, this.endAllSignal, this.monitor, backend));
        }
        executor.shutdown();
        this.endAllSignal.await();
    }

    private void afterBatch(BatchBackend backend) {
        Set targetedClasses = this.searchFactoryImplementor.getIndexedTypesPolymorphic((Class[])this.rootEntities);
        if (this.optimizeAtEnd) {
            backend.optimize(targetedClasses);
        }
        backend.flush(targetedClasses);
    }

    private void beforeBatch(BatchBackend backend) {
        if (this.purgeAtStart) {
            Set targetedClasses = this.searchFactoryImplementor.getIndexedTypesPolymorphic((Class[])this.rootEntities);
            for (Class clazz : targetedClasses) {
                backend.doWorkInSync((LuceneWork)new PurgeAllLuceneWork(clazz));
            }
            if (this.optimizeAfterPurge) {
                backend.optimize(targetedClasses);
            }
        }
    }
}

