/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.RootReturn;
import org.hibernate.loader.custom.ScalarReturn;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.loader.impl.OgmLoader;
import org.hibernate.ogm.loader.impl.OgmLoadingContext;
import org.hibernate.ogm.loader.nativeloader.impl.BackendCustomQuery;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.type.Type;

public class BackendCustomLoader
extends CustomLoader {
    private final CustomQuery customQuery;
    private final TypeTranslator typeTranslator;
    private final BackendCustomLoaderContext<?> loaderContext;

    public BackendCustomLoader(BackendCustomQuery<?> customQuery, SessionFactoryImplementor factory) {
        super(customQuery, factory);
        this.customQuery = customQuery;
        this.typeTranslator = (TypeTranslator)factory.getServiceRegistry().getService(TypeTranslator.class);
        this.loaderContext = BackendCustomLoader.getLoaderContext(customQuery, factory);
    }

    public Set<String> getQuerySpaces() {
        Set querySpaces = super.getQuerySpaces();
        return querySpaces;
    }

    private static <T extends Serializable> BackendCustomLoaderContext<T> getLoaderContext(BackendCustomQuery<T> customQuery, SessionFactoryImplementor factory) {
        QueryableGridDialect gridDialect = (QueryableGridDialect)factory.getServiceRegistry().getService(QueryableGridDialect.class);
        return new BackendCustomLoaderContext<T>(gridDialect, customQuery);
    }

    private boolean isEntityQuery() {
        for (Return queryReturn : this.customQuery.getCustomQueryReturns()) {
            if (!(queryReturn instanceof RootReturn)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<?> list(SessionImplementor session, QueryParameters queryParameters, Set querySpaces, Type[] resultTypes) throws HibernateException {
        ClosableIterator<Tuple> tuples = this.loaderContext.executeQuery(queryParameters);
        try {
            if (this.isEntityQuery()) {
                List<Object> list = this.listOfEntities(session, resultTypes, tuples);
                return list;
            }
            List<Object> list = this.listOfArrays(session, tuples);
            return list;
        }
        finally {
            tuples.close();
        }
    }

    private List<Object> listOfEntities(SessionImplementor session, Type[] resultTypes, ClosableIterator<Tuple> tuples) {
        ArrayList<Object> results = new ArrayList<Object>();
        Class returnedClass = resultTypes[0].getReturnedClass();
        while (tuples.hasNext()) {
            Tuple tuple = (Tuple)tuples.next();
            OgmLoader loader = this.createLoader(session, returnedClass);
            results.add(this.entity(session, tuple, loader));
        }
        return results;
    }

    private List<Object> listOfArrays(SessionImplementor session, Iterator<Tuple> tuples) {
        ArrayList<Object> results = new ArrayList<Object>();
        while (tuples.hasNext()) {
            int i;
            Tuple tuple = tuples.next();
            Object[] entry = null;
            if (!this.customQuery.getCustomQueryReturns().isEmpty()) {
                entry = new Object[this.customQuery.getCustomQueryReturns().size()];
                i = 0;
                for (Return queryReturn : this.customQuery.getCustomQueryReturns()) {
                    ScalarReturn scalarReturn = (ScalarReturn)queryReturn;
                    Type type = scalarReturn.getType();
                    if (type != null) {
                        GridType gridType = this.typeTranslator.getType(type);
                        entry[i++] = gridType.nullSafeGet(tuple, scalarReturn.getColumnAlias(), session, null);
                        continue;
                    }
                    entry[i++] = tuple.get(scalarReturn.getColumnAlias());
                }
            } else {
                entry = new Object[tuple.getColumnNames().size()];
                i = 0;
                for (String column : tuple.getColumnNames()) {
                    entry[i++] = tuple.get(column);
                }
            }
            if (entry.length == 1) {
                results.add(entry[0]);
                continue;
            }
            results.add(entry);
        }
        return results;
    }

    private <T> T entity(SessionImplementor session, Tuple tuple, OgmLoader loader) {
        OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
        ogmLoadingContext.setTuples(Arrays.asList(tuple));
        List<Object> entities = loader.loadEntities(session, LockOptions.NONE, ogmLoadingContext);
        return (T)entities.get(0);
    }

    private OgmLoader createLoader(SessionImplementor session, Class<?> entityClass) {
        OgmEntityPersister persister = (OgmEntityPersister)session.getFactory().getEntityPersister(entityClass.getName());
        OgmLoader loader = new OgmLoader(new OgmEntityPersister[]{persister});
        return loader;
    }

    private static class BackendCustomLoaderContext<T extends Serializable> {
        private final QueryableGridDialect<T> gridDialect;
        private final BackendQuery<T> query;

        public BackendCustomLoaderContext(QueryableGridDialect<T> gridDialect, BackendCustomQuery<T> customQuery) {
            this.gridDialect = gridDialect;
            this.query = new BackendQuery<T>(customQuery.getQueryObject(), customQuery.getSingleEntityKeyMetadataOrNull());
        }

        public ClosableIterator<Tuple> executeQuery(QueryParameters queryParameters) {
            return this.gridDialect.executeBackendQuery(this.query, queryParameters);
        }
    }
}

