/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.util.impl.StringHelper;

public class TupleContextImpl
implements TupleContext {
    private final List<String> selectableColumns;
    private final OptionsContext optionsContext;
    private final OperationsQueue operationsQueue;
    private final Map<String, AssociatedEntityKeyMetadata> associatedEntityMetadata;
    private final Map<String, String> roles;

    public TupleContextImpl(TupleContextImpl original, OperationsQueue operationsQueue) {
        this(original.selectableColumns, original.associatedEntityMetadata, original.roles, original.optionsContext, operationsQueue);
    }

    public TupleContextImpl(List<String> selectableColumns, Map<String, AssociatedEntityKeyMetadata> associatedEntityMetadata, Map<String, String> roles, OptionsContext optionsContext) {
        this(selectableColumns, associatedEntityMetadata, roles, optionsContext, null);
    }

    private TupleContextImpl(List<String> selectableColumns, Map<String, AssociatedEntityKeyMetadata> associatedEntityMetadata, Map<String, String> roles, OptionsContext optionsContext, OperationsQueue operationsQueue) {
        this.selectableColumns = selectableColumns;
        this.associatedEntityMetadata = Collections.unmodifiableMap(associatedEntityMetadata);
        this.roles = Collections.unmodifiableMap(roles);
        this.optionsContext = optionsContext;
        this.operationsQueue = operationsQueue;
    }

    @Override
    public List<String> getSelectableColumns() {
        return this.selectableColumns;
    }

    @Override
    public OptionsContext getOptionsContext() {
        return this.optionsContext;
    }

    @Override
    public boolean isPartOfAssociation(String column) {
        return this.associatedEntityMetadata.containsKey(column);
    }

    @Override
    public AssociatedEntityKeyMetadata getAssociatedEntityKeyMetadata(String column) {
        return this.associatedEntityMetadata.get(column);
    }

    @Override
    public Map<String, AssociatedEntityKeyMetadata> getAllAssociatedEntityKeyMetadata() {
        return this.associatedEntityMetadata;
    }

    @Override
    public String getRole(String column) {
        return this.roles.get(column);
    }

    @Override
    public Map<String, String> getAllRoles() {
        return this.roles;
    }

    @Override
    public OperationsQueue getOperationsQueue() {
        return this.operationsQueue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Tuple Context {");
        builder.append(StringHelper.join(this.selectableColumns, ", "));
        builder.append("}");
        return builder.toString();
    }
}

