/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.DialectFactoryInitiator;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfoSource;
import org.hibernate.ogm.dialect.impl.OgmDialect;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.service.impl.OptionalServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class OgmDialectFactoryInitiator
extends OptionalServiceInitiator<DialectFactory> {
    public static OgmDialectFactoryInitiator INSTANCE = new OgmDialectFactoryInitiator();

    @Override
    protected DialectFactory buildServiceInstance(Map configurationValues, ServiceRegistryImplementor registry) {
        return new OgmDialectFactory(registry);
    }

    @Override
    protected StandardServiceInitiator<DialectFactory> backupInitiator() {
        return DialectFactoryInitiator.INSTANCE;
    }

    public Class<DialectFactory> getServiceInitiated() {
        return DialectFactory.class;
    }

    private static class OgmDialectFactory
    implements DialectFactory {
        private final GridDialect gridDialect;

        public OgmDialectFactory(ServiceRegistryImplementor registry) {
            this.gridDialect = (GridDialect)registry.getService(GridDialect.class);
        }

        public Dialect buildDialect(Map configValues, DialectResolutionInfoSource resolutionInfoSource) throws HibernateException {
            return new OgmDialect(this.gridDialect);
        }
    }
}

