/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.spi;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.id.spi.PersistentNoSqlIdentifierGenerator;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class BaseSchemaDefiner
implements SchemaDefiner {
    @Override
    public void validateMapping(SessionFactoryImplementor factory) {
    }

    @Override
    public void initializeSchema(Configuration configuration, SessionFactoryImplementor factory) {
    }

    protected Set<PersistentNoSqlIdentifierGenerator> getPersistentGenerators(SessionFactoryImplementor factory) {
        Map entityPersisters = factory.getEntityPersisters();
        HashSet<PersistentNoSqlIdentifierGenerator> persistentGenerators = new HashSet<PersistentNoSqlIdentifierGenerator>(entityPersisters.size());
        for (EntityPersister persister : entityPersisters.values()) {
            if (!(persister.getIdentifierGenerator() instanceof PersistentNoSqlIdentifierGenerator)) continue;
            persistentGenerators.add((PersistentNoSqlIdentifierGenerator)persister.getIdentifierGenerator());
        }
        return persistentGenerators;
    }

    protected Set<IdSourceKeyMetadata> getAllIdSourceKeyMetadata(SessionFactoryImplementor factory) {
        HashSet<IdSourceKeyMetadata> allIdSourceKeyMetadata = new HashSet<IdSourceKeyMetadata>();
        for (PersistentNoSqlIdentifierGenerator generator : this.getPersistentGenerators(factory)) {
            allIdSourceKeyMetadata.add(generator.getGeneratorKeyMetadata());
        }
        return allIdSourceKeyMetadata;
    }

    protected Set<EntityKeyMetadata> getAllEntityKeyMetadata(SessionFactoryImplementor factory) {
        HashSet<EntityKeyMetadata> allEntityKeyMetadata = new HashSet<EntityKeyMetadata>();
        for (EntityPersister entityPersister : factory.getEntityPersisters().values()) {
            allEntityKeyMetadata.add(((OgmEntityPersister)entityPersister).getEntityKeyMetadata());
        }
        return allEntityKeyMetadata;
    }

    protected Set<AssociationKeyMetadata> getAllAssociationKeyMetadata(SessionFactoryImplementor factory) {
        HashSet<AssociationKeyMetadata> allAssociationKeyMetadata = new HashSet<AssociationKeyMetadata>();
        for (CollectionPersister associationPersister : factory.getCollectionPersisters().values()) {
            allAssociationKeyMetadata.add(((OgmCollectionPersister)associationPersister).getAssociationKeyMetadata());
        }
        for (EntityPersister entityPersister : factory.getEntityPersisters().values()) {
            for (String property : entityPersister.getPropertyNames()) {
                AssociationKeyMetadata inverseOneToOneAssociationKeyMetadata = ((OgmEntityPersister)entityPersister).getInverseOneToOneAssociationKeyMetadata(property);
                if (inverseOneToOneAssociationKeyMetadata == null) continue;
                allAssociationKeyMetadata.add(inverseOneToOneAssociationKeyMetadata);
            }
        }
        return allAssociationKeyMetadata;
    }
}

