/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.impl;

public enum AvailableDatastoreProvider {
    MAP("org.hibernate.ogm.datastore.map.impl.MapDatastoreProvider"),
    INFINISPAN("org.hibernate.ogm.datastore.infinispan.impl.InfinispanDatastoreProvider"),
    EHCACHE("org.hibernate.ogm.datastore.ehcache.impl.EhcacheDatastoreProvider"),
    MONGODB("org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider"),
    NEO4J_EMBEDDED("org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider"),
    COUCHDB_EXPERIMENTAL("org.hibernate.ogm.datastore.couchdb.impl.CouchDBDatastoreProvider");

    private String datastoreProviderClassName;

    private AvailableDatastoreProvider(String datastoreProviderClassName) {
        this.datastoreProviderClassName = datastoreProviderClassName;
    }

    public String getDatastoreProviderClassName() {
        return this.datastoreProviderClassName;
    }

    public static boolean isShortName(String name) {
        for (AvailableDatastoreProvider provider : AvailableDatastoreProvider.values()) {
            if (!provider.name().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static AvailableDatastoreProvider byShortName(String shortName) {
        return AvailableDatastoreProvider.valueOf(shortName.toUpperCase());
    }
}

