/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.id.spi.PersistentNoSqlIdentifierGenerator;

public class MongoDBEntityMappingValidator
extends BaseSchemaDefiner {
    private static final Log log = LoggerFactory.getLogger();

    public void validateMapping(SessionFactoryImplementor factory) {
        Set persistentGenerators = this.getPersistentGenerators(factory);
        this.validateGenerators(persistentGenerators);
    }

    private void validateGenerators(Iterable<PersistentNoSqlIdentifierGenerator> generators) {
        for (PersistentNoSqlIdentifierGenerator identifierGenerator : generators) {
            String keyColumn = identifierGenerator.getGeneratorKeyMetadata().getKeyColumnName();
            if (keyColumn.equals("_id")) continue;
            log.cannotUseGivenPrimaryKeyColumnName(keyColumn, "_id");
        }
    }
}

