/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.dialect.impl;

import java.io.Serializable;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.datastore.infinispan.impl.InfinispanEmbeddedDatastoreProvider;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.KeyProvider;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.model.impl.EntityKeyBuilder;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.persister.entity.Lockable;
import org.infinispan.AdvancedCache;

public class InfinispanPessimisticWriteLockingStrategy<EK>
implements LockingStrategy {
    private static final Log log = LoggerFactory.make();
    protected final GridType identifierGridType;
    private final LockMode lockMode;
    private final Lockable lockable;
    private final InfinispanEmbeddedDatastoreProvider provider;

    public InfinispanPessimisticWriteLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockMode = lockMode;
        this.lockable = lockable;
        TypeTranslator typeTranslator = (TypeTranslator)lockable.getFactory().getServiceRegistry().getService(TypeTranslator.class);
        this.identifierGridType = typeTranslator.getType(lockable.getIdentifierType());
        this.provider = InfinispanPessimisticWriteLockingStrategy.getProvider(lockable.getFactory());
    }

    public void lock(Serializable id, Object version, Object object, int timeout, SessionImplementor session) throws StaleObjectStateException, JDBCException {
        LocalCacheManager<EK, ?, ?> cacheManager = this.getCacheManager();
        KeyProvider<EK, ?, ?> keyProvider = this.getKeyProvider();
        AdvancedCache advCache = cacheManager.getEntityCache(((OgmEntityPersister)this.lockable).getRootEntityKeyMetadata()).getAdvancedCache();
        EntityKey key = EntityKeyBuilder.fromData((EntityKeyMetadata)((OgmEntityPersister)this.lockable).getRootEntityKeyMetadata(), (GridType)this.identifierGridType, (Serializable)id, (SessionImplementor)session);
        advCache.lock(new Object[]{keyProvider.getEntityCacheKey(key)});
    }

    private static InfinispanEmbeddedDatastoreProvider getProvider(SessionFactoryImplementor factory) {
        DatastoreProvider service = (DatastoreProvider)factory.getServiceRegistry().getService(DatastoreProvider.class);
        if (service instanceof InfinispanEmbeddedDatastoreProvider) {
            return (InfinispanEmbeddedDatastoreProvider)((Object)InfinispanEmbeddedDatastoreProvider.class.cast(service));
        }
        throw log.unexpectedDatastoreProvider(service.getClass(), InfinispanEmbeddedDatastoreProvider.class);
    }

    private LocalCacheManager<EK, ?, ?> getCacheManager() {
        return this.provider.getCacheManager();
    }

    private KeyProvider<EK, ?, ?> getKeyProvider() {
        return this.provider.getKeyProvider();
    }
}

