/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.dialect.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class EntityKeyMetadataExternalizer
implements AdvancedExternalizer<EntityKeyMetadata> {
    public static final EntityKeyMetadataExternalizer INSTANCE = new EntityKeyMetadataExternalizer();
    private static final int VERSION = 1;
    private static final Set<Class<? extends EntityKeyMetadata>> TYPE_CLASSES = Collections.singleton(EntityKeyMetadata.class);

    private EntityKeyMetadataExternalizer() {
    }

    public void writeObject(ObjectOutput output, EntityKeyMetadata metadata) throws IOException {
        output.writeInt(1);
        output.writeUTF(metadata.getTable());
        output.writeObject(metadata.getColumnNames());
    }

    public EntityKeyMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        input.readInt();
        String tableName = input.readUTF();
        String[] columnNames = (String[])input.readObject();
        return new EntityKeyMetadata(tableName, columnNames);
    }

    public Set<Class<? extends EntityKeyMetadata>> getTypeClasses() {
        return TYPE_CLASSES;
    }

    public Integer getId() {
        return 1403;
    }
}

