/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.infinispan;

import java.io.Serializable;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.datastore.infinispan.impl.InfinispanDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.persister.EntityKeyBuilder;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.TypeTranslator;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.persister.entity.Lockable;
import org.infinispan.AdvancedCache;

public class InfinispanPessimisticWriteLockingStrategy
implements LockingStrategy {
    private final LockMode lockMode;
    private final Lockable lockable;
    private volatile InfinispanDatastoreProvider provider;
    private static final Log log = LoggerFactory.make();
    protected final GridType identifierGridType;

    public InfinispanPessimisticWriteLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockMode = lockMode;
        this.lockable = lockable;
        TypeTranslator typeTranslator = (TypeTranslator)lockable.getFactory().getServiceRegistry().getService(TypeTranslator.class);
        this.identifierGridType = typeTranslator.getType(lockable.getIdentifierType());
    }

    public void lock(Serializable id, Object version, Object object, int timeout, SessionImplementor session) throws StaleObjectStateException, JDBCException {
        AdvancedCache advCache = this.getProvider(session).getCache("ENTITIES").getAdvancedCache();
        EntityKey key = EntityKeyBuilder.fromData((String)this.lockable.getRootTableName(), (String[])this.lockable.getRootTableIdentifierColumnNames(), (GridType)this.identifierGridType, (Serializable)id, (SessionImplementor)session);
        advCache.lock(new Object[]{key});
    }

    private InfinispanDatastoreProvider getProvider(SessionImplementor session) {
        if (this.provider == null) {
            DatastoreProvider service = (DatastoreProvider)session.getFactory().getServiceRegistry().getService(DatastoreProvider.class);
            if (service instanceof InfinispanDatastoreProvider) {
                this.provider = (InfinispanDatastoreProvider)InfinispanDatastoreProvider.class.cast(service);
            } else {
                log.unexpectedDatastoreProvider(service.getClass(), InfinispanDatastoreProvider.class);
            }
        }
        return this.provider;
    }
}

