/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.infinispan;

import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.ogm.datastore.impl.EmptyTupleSnapshot;
import org.hibernate.ogm.datastore.impl.MapHelpers;
import org.hibernate.ogm.datastore.infinispan.impl.InfinispanDatastoreProvider;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.infinispan.InfinispanPessimisticWriteLockingStrategy;
import org.hibernate.ogm.dialect.infinispan.InfinispanTupleSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.type.GridType;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.Type;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.context.Flag;

public class InfinispanDialect
implements GridDialect {
    private final InfinispanDatastoreProvider provider;

    public InfinispanDialect(InfinispanDatastoreProvider provider) {
        this.provider = provider;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_WRITE) {
            return new InfinispanPessimisticWriteLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_READ) {
            return new InfinispanPessimisticWriteLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        throw new UnsupportedOperationException("LockMode " + lockMode + " is not supported by the Infinispan GridDialect");
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Cache cache = this.provider.getCache("ENTITIES");
        FineGrainedAtomicMap atomicMap = AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache, (Object)key, (boolean)false);
        if (atomicMap == null) {
            return null;
        }
        return new Tuple((TupleSnapshot)new InfinispanTupleSnapshot((FineGrainedAtomicMap<String, Object>)atomicMap));
    }

    public Tuple createTuple(EntityKey key) {
        Cache cache = this.provider.getCache("ENTITIES");
        FineGrainedAtomicMap atomicMap = AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache, (Object)key, (boolean)true);
        return new Tuple((TupleSnapshot)new InfinispanTupleSnapshot((FineGrainedAtomicMap<String, Object>)atomicMap));
    }

    public void updateTuple(Tuple tuple, EntityKey key) {
        FineGrainedAtomicMap<String, Object> atomicMap = ((InfinispanTupleSnapshot)tuple.getSnapshot()).getAtomicMap();
        MapHelpers.applyTupleOpsOnMap((Tuple)tuple, atomicMap);
    }

    public void removeTuple(EntityKey key) {
        Cache cache = this.provider.getCache("ENTITIES");
        AtomicMapLookup.removeAtomicMap((Cache)cache, (Object)key);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache cache = this.provider.getCache("ASSOCIATIONS");
        FineGrainedAtomicMap atomicMap = AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache, (Object)key, (boolean)false);
        return atomicMap == null ? null : new Association((AssociationSnapshot)new MapAssociationSnapshot((Map)atomicMap));
    }

    public Association createAssociation(AssociationKey key) {
        Cache cache = this.provider.getCache("ASSOCIATIONS");
        FineGrainedAtomicMap atomicMap = AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache, (Object)key, (boolean)true);
        return new Association((AssociationSnapshot)new MapAssociationSnapshot((Map)atomicMap));
    }

    public void updateAssociation(Association association, AssociationKey key) {
        MapHelpers.updateAssociation((Association)association, (AssociationKey)key);
    }

    public void removeAssociation(AssociationKey key) {
        Cache cache = this.provider.getCache("ASSOCIATIONS");
        AtomicMapLookup.removeAtomicMap((Cache)cache, (Object)key);
    }

    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        return new Tuple(EmptyTupleSnapshot.SINGLETON);
    }

    public void nextValue(RowKey key, IntegralDataTypeHolder value, int increment, int initialValue) {
        IntegralDataTypeHolder updateValue;
        Number newValueFromDb;
        Object valueFromDb;
        AdvancedCache identifierCache = this.provider.getCache("IDENTIFIERS").getAdvancedCache();
        boolean done = false;
        do {
            if ((valueFromDb = identifierCache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)key)) == null) {
                value.initialize((long)initialValue);
                valueFromDb = new Long(value.makeValue().longValue());
                Object oldValue = identifierCache.putIfAbsent((Object)key, valueFromDb);
                if (oldValue != null) {
                    value.initialize(((Number)oldValue).longValue());
                    valueFromDb = oldValue;
                }
            } else {
                value.initialize(((Number)valueFromDb).longValue());
            }
            updateValue = value.copy();
            updateValue.add((long)increment);
        } while (!(done = identifierCache.replace((Object)key, valueFromDb, (Object)(newValueFromDb = updateValue.makeValue()))));
    }

    public GridType overrideType(Type type) {
        return null;
    }
}

