/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.infinispan.impl.TransactionManagerLookupDelegator;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.infinispan.InfinispanDialect;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.service.jndi.spi.JndiService;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.FileLookupFactory;

public class InfinispanDatastoreProvider
implements DatastoreProvider,
Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    private JtaPlatform jtaPlatform;
    private JndiService jndiService;
    private Map cfg;
    private Map<String, Cache> caches;
    private boolean isCacheProvided;
    private boolean started = false;
    public static final String INFINISPAN_CONFIGURATION_RESOURCENAME = "hibernate.ogm.infinispan.configuration_resourcename";
    public static final String CACHE_MANAGER_RESOURCE_PROP = "hibernate.ogm.infinispan.cachemanager_jndiname";
    public static final String INFINISPAN_DEFAULT_CONFIG = "org/hibernate/ogm/datastore/infinispan/default-config.xml";
    private static final Log log = LoggerFactory.make();
    private EmbeddedCacheManager cacheManager;

    public Class<? extends GridDialect> getDefaultDialect() {
        return InfinispanDialect.class;
    }

    public void start() {
        if (this.started) {
            return;
        }
        try {
            String jndiProperty = (String)this.cfg.get(CACHE_MANAGER_RESOURCE_PROP);
            if (jndiProperty == null) {
                String cfgName = (String)this.cfg.get(INFINISPAN_CONFIGURATION_RESOURCENAME);
                if (StringHelper.isEmpty((String)cfgName)) {
                    cfgName = INFINISPAN_DEFAULT_CONFIG;
                }
                log.tracef("Initializing Infinispan from configuration file at %1$s", (Object)cfgName);
                this.cacheManager = this.createCustomCacheManager(cfgName, this.jtaPlatform);
                this.isCacheProvided = false;
            } else {
                log.tracef("Retrieving Infinispan from JNDI at %1$s", (Object)jndiProperty);
                this.cacheManager = (EmbeddedCacheManager)this.jndiService.locate(jndiProperty);
                this.isCacheProvided = true;
            }
        }
        catch (RuntimeException e) {
            throw log.unableToInitializeInfinispan(e);
        }
        this.eagerlyInitializeCaches(this.cacheManager);
        this.jtaPlatform = null;
        this.jndiService = null;
        this.cfg = null;
        this.started = true;
    }

    private void eagerlyInitializeCaches(EmbeddedCacheManager cacheManager) {
        this.caches = new ConcurrentHashMap<String, Cache>(3);
        this.putInLocalCache(cacheManager, "ASSOCIATIONS");
        this.putInLocalCache(cacheManager, "ENTITIES");
        this.putInLocalCache(cacheManager, "IDENTIFIERS");
    }

    private void putInLocalCache(EmbeddedCacheManager cacheManager, String cacheName) {
        this.caches.put(cacheName, cacheManager.getCache(cacheName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmbeddedCacheManager createCustomCacheManager(String cfgName, JtaPlatform platform) {
        EmbeddedCacheManager embeddedCacheManager;
        block8: {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            TransactionManagerLookupDelegator transactionManagerLookupDelegator = new TransactionManagerLookupDelegator(platform);
            InputStream configurationFile = FileLookupFactory.newInstance().lookupFileStrict(cfgName, contextClassLoader);
            try {
                this.cacheManager = new DefaultCacheManager(configurationFile, false);
                for (String cacheName : this.cacheManager.getCacheNames()) {
                    Configuration originalCfg = this.cacheManager.getCacheConfiguration(cacheName);
                    Configuration newCfg = new ConfigurationBuilder().read(originalCfg).transaction().transactionManagerLookup((TransactionManagerLookup)transactionManagerLookupDelegator).build();
                    this.cacheManager.defineConfiguration(cacheName, newCfg);
                }
                this.cacheManager.start();
                embeddedCacheManager = this.cacheManager;
                if (configurationFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (configurationFile != null) {
                        configurationFile.close();
                    }
                    throw throwable;
                }
                catch (RuntimeException re) {
                    throw this.raiseConfigurationError(re, cfgName);
                }
                catch (IOException e) {
                    throw this.raiseConfigurationError(e, cfgName);
                }
            }
            configurationFile.close();
        }
        return embeddedCacheManager;
    }

    public EmbeddedCacheManager getEmbeddedCacheManager() {
        return this.cacheManager;
    }

    public Cache getCache(String name) {
        return this.caches.get(name);
    }

    public void stop() {
        if (!this.isCacheProvided && this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }

    private HibernateException raiseConfigurationError(Exception e, String cfgName) {
        return new HibernateException("Could not start Infinispan CacheManager using as configuration file: " + cfgName, (Throwable)e);
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.jtaPlatform = (JtaPlatform)serviceRegistry.getService(JtaPlatform.class);
        this.jndiService = (JndiService)serviceRegistry.getService(JndiService.class);
    }

    public void configure(Map configurationValues) {
        this.cfg = configurationValues;
    }
}

