/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.utils;

import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ogm.cfg.OgmConfiguration;
import org.hibernate.ogm.test.utils.TestHelper;
import org.junit.rules.TemporaryFolder;

public class SessionFactoryRule
extends TemporaryFolder {
    private final Class<?>[] entities;
    private final OgmConfiguration cfg = new OgmConfiguration();
    private SessionFactory sessions;
    private Session session;

    public SessionFactoryRule(Class<?> ... entities) {
        if (entities == null || entities.length == 0) {
            throw new IllegalArgumentException("Define at least a single annotated entity");
        }
        this.entities = entities;
        this.cfg.setProperty("hibernate.hbm2ddl.auto", "none");
        this.cfg.setProperty("hibernate.id.new_generator_mappings", "true");
        this.cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        this.cfg.setProperty("hibernate.search.lucene_version", "LUCENE_35");
        for (Map.Entry<String, String> entry : TestHelper.getEnvironmentProperties().entrySet()) {
            this.cfg.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public SessionFactoryRule setProperty(String key, String value) {
        if (this.sessions != null) {
            throw new IllegalStateException("SessionFactory already created");
        }
        this.cfg.setProperty(key, value);
        return this;
    }

    public void before() throws Throwable {
        super.before();
        this.getSessionFactory();
    }

    public void after() {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
            System.err.println("Had to close your lingering Session");
        }
        if (this.sessions != null) {
            this.sessions.close();
        }
        super.after();
    }

    public Session openSession() {
        if (this.session == null || !this.session.isOpen()) {
            return this.getSessionFactory().openSession();
        }
        throw new IllegalStateException("Previous session not closed! Manage your own if you need multiple sessions.");
    }

    public SessionFactory getSessionFactory() {
        if (this.sessions == null) {
            for (Class<?> annotatedClass : this.entities) {
                this.cfg.addAnnotatedClass(annotatedClass);
            }
            this.sessions = this.cfg.buildSessionFactory();
        }
        return this.sessions;
    }

    static {
        TestHelper.initializeHelpers();
    }
}

