/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.utils;

import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.infinispan.impl.InfinispanDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.test.utils.TestableGridDialect;
import org.infinispan.Cache;

public class InfinispanTestHelper
implements TestableGridDialect {
    @Override
    public boolean assertNumberOfEntities(int numberOfEntities, SessionFactory sessionFactory) {
        return InfinispanTestHelper.getEntityCache(sessionFactory).size() == numberOfEntities;
    }

    @Override
    public boolean assertNumberOfAssociations(int numberOfAssociations, SessionFactory sessionFactory) {
        return InfinispanTestHelper.getAssociationCache(sessionFactory).size() == numberOfAssociations;
    }

    @Override
    public Map<String, Object> extractEntityTuple(SessionFactory sessionFactory, EntityKey key) {
        return (Map)InfinispanTestHelper.getEntityCache(sessionFactory).get((Object)key);
    }

    private static Cache getEntityCache(SessionFactory sessionFactory) {
        InfinispanDatastoreProvider castProvider = InfinispanTestHelper.getProvider(sessionFactory);
        return castProvider.getCache("ENTITIES");
    }

    public static InfinispanDatastoreProvider getProvider(SessionFactory sessionFactory) {
        DatastoreProvider provider = (DatastoreProvider)((SessionFactoryImplementor)sessionFactory).getServiceRegistry().getService(DatastoreProvider.class);
        if (!InfinispanDatastoreProvider.class.isInstance(provider)) {
            throw new RuntimeException("Not testing with Infinispan, cannot extract underlying cache");
        }
        return (InfinispanDatastoreProvider)InfinispanDatastoreProvider.class.cast(provider);
    }

    private static Cache getAssociationCache(SessionFactory sessionFactory) {
        InfinispanDatastoreProvider castProvider = InfinispanTestHelper.getProvider(sessionFactory);
        return castProvider.getCache("ASSOCIATIONS");
    }

    @Override
    public boolean backendSupportsTransactions() {
        return true;
    }

    @Override
    public void dropSchemaAndDatabase(SessionFactory sessionFactory) {
    }

    @Override
    public Map<String, String> getEnvironmentProperties() {
        return null;
    }
}

