/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.type;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.type.AbstractGenericBasicType;
import org.hibernate.ogm.type.descriptor.BasicGridBinder;
import org.hibernate.ogm.type.descriptor.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.GridValueBinder;
import org.hibernate.ogm.type.descriptor.GridValueExtractor;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcDateTypeDescriptor;

public class CustomDateType
extends AbstractGenericBasicType<Date> {
    private static final Log log = LoggerFactory.make();
    public static CustomDateType INSTANCE = new CustomDateType();

    public CustomDateType() {
        super((GridTypeDescriptor)CustomDateTypeDescriptor.INSTANCE, (JavaTypeDescriptor)JdbcDateTypeDescriptor.INSTANCE);
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return 1;
    }

    public String getName() {
        return "date";
    }

    static class CustomDateTypeDescriptor
    implements GridTypeDescriptor {
        public static CustomDateTypeDescriptor INSTANCE = new CustomDateTypeDescriptor();

        CustomDateTypeDescriptor() {
        }

        public <Date> GridValueBinder<Date> getBinder(JavaTypeDescriptor<Date> javaTypeDescriptor) {
            return new BasicGridBinder<Date>(javaTypeDescriptor, this){

                protected void doBind(Tuple resultset, Date value, String[] names, WrapperOptions options) {
                    String stringDate = new SimpleDateFormat("yyyyMMdd").format(value);
                    resultset.put(names[0], (Object)stringDate);
                }
            };
        }

        public <X> GridValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new GridValueExtractor<X>(){

                public X extract(Tuple resultset, String name) {
                    String result = (String)resultset.get(name);
                    if (result == null) {
                        log.tracef("found [null] as column [$s]", (Object)name);
                        return null;
                    }
                    Date date = null;
                    try {
                        date = new SimpleDateFormat("yyyyMMdd").parse(result);
                    }
                    catch (ParseException e) {
                        throw new HibernateException("Unable to read date from datastore " + result, (Throwable)e);
                    }
                    if (log.isTraceEnabled()) {
                        log.tracef("found [$s] as column [$s]", (Object)result, (Object)name);
                    }
                    return date;
                }
            };
        }
    }
}

