/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.simpleentity;

import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.test.simpleentity.Helicopter;
import org.hibernate.ogm.test.simpleentity.Hypothesis;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;

public class CRUDTest
extends OgmTestCase {
    public void testSimpleCRUD() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Hypothesis hyp = new Hypothesis();
        hyp.setId("1234567890");
        hyp.setDescription("NP != P");
        hyp.setPosition(1);
        session.persist((Object)hyp);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Hypothesis loadedHyp = (Hypothesis)session.get(Hypothesis.class, (Serializable)((Object)hyp.getId()));
        CRUDTest.assertNotNull((String)"Cannot load persisted object", (Object)loadedHyp);
        CRUDTest.assertEquals((String)"persist and load fails", (String)hyp.getDescription(), (String)loadedHyp.getDescription());
        CRUDTest.assertEquals((String)"@Column fails", (int)hyp.getPosition(), (int)loadedHyp.getPosition());
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedHyp.setDescription("P != NP");
        session.merge((Object)loadedHyp);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Hypothesis secondLoadedHyp = (Hypothesis)session.get(Hypothesis.class, (Serializable)((Object)hyp.getId()));
        CRUDTest.assertEquals((String)"Merge fails", (String)loadedHyp.getDescription(), (String)secondLoadedHyp.getDescription());
        session.delete((Object)secondLoadedHyp);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        CRUDTest.assertNull((Object)session.get(Hypothesis.class, (Serializable)((Object)hyp.getId())));
        transaction.commit();
        session.close();
    }

    private void performanceLoop() throws Exception {
        long start = 0L;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (i % 10000 == 0) {
                start = System.nanoTime();
            }
            this.testSimpleCRUD();
            if (i % 10000 != 9999) continue;
            long elapsed = System.nanoTime() - start;
            System.out.printf("%.3E ms for 10000 tests\n", Float.valueOf((float)elapsed / 1000000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CRUDTest test = new CRUDTest();
        test.setUp();
        try {
            test.performanceLoop();
        }
        finally {
            test.tearDown();
        }
    }

    public void testGeneratedValue() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Helicopter h = new Helicopter();
        h.setName("Eurocopter");
        session.persist((Object)h);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        h = (Helicopter)session.get(Helicopter.class, (Serializable)((Object)h.getUUID()));
        session.delete((Object)h);
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Hypothesis.class, Helicopter.class};
    }
}

