/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.initialize;

import java.io.FileNotFoundException;
import junit.framework.Assert;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.ogm.cfg.OgmConfiguration;
import org.hibernate.ogm.test.utils.InfinispanTestHelper;
import org.junit.Test;

public class WrongConfigurationBootTest {
    @Test
    public void testSimpleInfinispanInitialization() {
        this.tryBoot("infinispan-local.xml");
    }

    @Test
    public void testIllegalInfinispanConfigurationReported() {
        try {
            this.tryBoot("does-not-exist-configuration-file.xml");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (HibernateException he) {
            Assert.assertTrue((boolean)he.getMessage().contains("Unable to find or initialize Infinispan CacheManager"));
            Throwable cause = he.getCause();
            Assert.assertTrue((boolean)cause.getMessage().contains("Could not start Infinispan CacheManager using as configuration file: does-not-exist-configuration-file.xml"));
            Throwable originalCause = cause.getCause();
            Assert.assertTrue((boolean)originalCause.getMessage().contains("does-not-exist-configuration-file.xml"));
            Assert.assertEquals(FileNotFoundException.class, originalCause.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBoot(String configurationResourceName) {
        OgmConfiguration cfg = new OgmConfiguration();
        cfg.setProperty("hibernate.ogm.datastore.provider", "infinispan");
        cfg.setProperty("hibernate.ogm.infinispan.configuration_resourcename", configurationResourceName);
        SessionFactory sessionFactory = cfg.buildSessionFactory();
        if (sessionFactory != null) {
            try {
                InfinispanTestHelper.getProvider(sessionFactory);
            }
            finally {
                sessionFactory.close();
            }
        }
    }
}

