/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.id;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.test.id.Actor;
import org.hibernate.ogm.test.id.Song;
import org.hibernate.ogm.test.utils.jpa.JpaTestCase;
import org.junit.Test;

public class SequenceIdGeneratorTest
extends JpaTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequenceIdGenerationInJTA() throws Exception {
        Song firstSong = new Song();
        Song secondSong = new Song();
        Actor firstActor = new Actor();
        Actor secondActor = new Actor();
        this.getTransactionManager().begin();
        EntityManager em = this.getFactory().createEntityManager();
        boolean operationSuccessfull = false;
        try {
            firstSong.setSinger("Charlotte Church");
            firstSong.setTitle("Ave Maria");
            em.persist((Object)firstSong);
            secondSong.setSinger("Charlotte Church");
            secondSong.setTitle("Flower Duet");
            em.persist((Object)secondSong);
            firstActor.setName("Russell Crowe");
            firstActor.setBestMovieTitle("Gladiator");
            em.persist((Object)firstActor);
            secondActor.setName("Johnny Depp");
            secondActor.setBestMovieTitle("Pirates of the Caribbean");
            em.persist((Object)secondActor);
            operationSuccessfull = true;
        }
        finally {
            this.commitOrRollback(operationSuccessfull);
        }
        em.clear();
        this.getTransactionManager().begin();
        operationSuccessfull = false;
        try {
            firstSong = (Song)em.find(Song.class, (Object)firstSong.getId());
            Assertions.assertThat((Object)firstSong).isNotNull();
            Assertions.assertThat((Long)firstSong.getId()).isEqualTo(2L);
            Assertions.assertThat((String)firstSong.getTitle()).isEqualTo((Object)"Ave Maria");
            em.remove((Object)firstSong);
            secondSong = (Song)em.find(Song.class, (Object)secondSong.getId());
            Assertions.assertThat((Object)secondSong).isNotNull();
            Assertions.assertThat((Long)secondSong.getId()).isEqualTo(3L);
            Assertions.assertThat((String)secondSong.getTitle()).isEqualTo((Object)"Flower Duet");
            em.remove((Object)secondSong);
            firstActor = (Actor)em.find(Actor.class, (Object)firstActor.getId());
            Assertions.assertThat((Object)firstActor).isNotNull();
            Assertions.assertThat((Long)firstActor.getId()).isEqualTo(1L);
            Assertions.assertThat((String)firstActor.getName()).isEqualTo((Object)"Russell Crowe");
            em.remove((Object)firstActor);
            secondActor = (Actor)em.find(Actor.class, (Object)secondActor.getId());
            Assertions.assertThat((Object)secondActor).isNotNull();
            Assertions.assertThat((Long)secondActor.getId()).isEqualTo(2L);
            Assertions.assertThat((String)secondActor.getName()).isEqualTo((Object)"Johnny Depp");
            em.remove((Object)secondActor);
            operationSuccessfull = true;
        }
        finally {
            this.commitOrRollback(operationSuccessfull);
        }
        em.close();
    }

    @Override
    public Class<?>[] getEntities() {
        return new Class[]{Song.class, Actor.class};
    }
}

