/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.id;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.test.id.Animal;
import org.hibernate.ogm.test.utils.jpa.JpaTestCase;
import org.junit.Test;

public class IdentityIdGeneratorTest
extends JpaTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdentityGenerator() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = this.getFactory().createEntityManager();
        Animal jungleKing = new Animal();
        Animal fish = new Animal();
        boolean ok = false;
        try {
            jungleKing.setName("Lion");
            jungleKing.setSpecies("Mammal");
            em.persist((Object)jungleKing);
            fish.setName("Shark");
            fish.setSpecies("Tiger Shark");
            em.persist((Object)fish);
            ok = true;
        }
        finally {
            this.commitOrRollback(ok);
        }
        em.clear();
        this.getTransactionManager().begin();
        ok = false;
        try {
            Animal animal = (Animal)em.find(Animal.class, (Object)jungleKing.getId());
            Assertions.assertThat((Object)animal).isNotNull();
            Assertions.assertThat((Long)animal.getId()).isEqualTo(1L);
            Assertions.assertThat((String)animal.getName()).isEqualTo((Object)"Lion");
            em.remove((Object)animal);
            animal = (Animal)em.find(Animal.class, (Object)fish.getId());
            Assertions.assertThat((Object)animal).isNotNull();
            Assertions.assertThat((Long)animal.getId()).isEqualTo(2L);
            Assertions.assertThat((String)animal.getName()).isEqualTo((Object)"Shark");
            em.remove((Object)animal);
            ok = true;
        }
        finally {
            this.commitOrRollback(ok);
        }
        em.close();
    }

    @Override
    public Class<?>[] getEntities() {
        return new Class[]{Animal.class};
    }
}

