/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.hsearch;

import java.util.List;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.ogm.test.hsearch.Insurance;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.junit.Test;

public class SearchOnStandaloneOGMTest
extends OgmTestCase {
    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.directory_provider", "ram");
    }

    @Test
    public void testHibernateSearchJPAAPIUsage() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        FullTextSession fts = Search.getFullTextSession((Session)session);
        Insurance insurance = new Insurance();
        insurance.setName("Macif");
        fts.persist((Object)insurance);
        transaction.commit();
        fts.clear();
        transaction = fts.beginTransaction();
        QueryBuilder b = fts.getSearchFactory().buildQueryBuilder().forEntity(Insurance.class).get();
        Query lq = b.keyword().onField("name").matching((Object)"Macif").createQuery();
        FullTextQuery ftQuery = fts.createFullTextQuery(lq, new Class[]{Insurance.class});
        ftQuery.initializeObjectsWith(ObjectLookupMethod.SKIP, DatabaseRetrievalMethod.FIND_BY_ID);
        List resultList = ftQuery.list();
        Assertions.assertThat((List)resultList).hasSize(1);
        for (Insurance e : resultList) {
            fts.delete((Object)e);
        }
        transaction.commit();
        fts.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Insurance.class};
    }
}

