/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.associations.manytoone;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.fest.assertions.CollectionAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.test.associations.manytoone.Beer;
import org.hibernate.ogm.test.associations.manytoone.Brewery;
import org.hibernate.ogm.test.associations.manytoone.JUG;
import org.hibernate.ogm.test.associations.manytoone.Member;
import org.hibernate.ogm.test.associations.manytoone.SalesForce;
import org.hibernate.ogm.test.associations.manytoone.SalesGuy;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;
import org.hibernate.ogm.test.utils.GridDialectType;
import org.hibernate.ogm.test.utils.SkipByGridDialect;
import org.hibernate.ogm.test.utils.TestHelper;

public class ManyToOneTest
extends OgmTestCase {
    @SkipByGridDialect(value={GridDialectType.INFINISPAN}, comment="AtomicMap diff algorithm does not take removal into account. This leads to the association entry not being removed despite being empty")
    public void testUnidirectionalManyToOne() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        JUG jug = new JUG();
        jug.setName("JUG Summer Camp");
        session.persist((Object)jug);
        Member emmanuel = new Member();
        emmanuel.setName("Emmanuel Bernard");
        emmanuel.setMemberOf(jug);
        Member jerome = new Member();
        jerome.setName("Jerome");
        jerome.setMemberOf(jug);
        session.persist((Object)emmanuel);
        session.persist((Object)jerome);
        session.flush();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(3, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(0, this.sessions)).isTrue();
        transaction.commit();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(3, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(0, this.sessions)).isTrue();
        session.clear();
        transaction = session.beginTransaction();
        emmanuel = (Member)session.get(Member.class, (Serializable)((Object)emmanuel.getId()));
        jug = emmanuel.getMemberOf();
        session.delete((Object)emmanuel);
        jerome = (Member)session.get(Member.class, (Serializable)((Object)jerome.getId()));
        session.delete((Object)jerome);
        session.delete((Object)jug);
        transaction.commit();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(0, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(0, this.sessions)).isTrue();
        session.close();
        this.checkCleanCache();
    }

    public void testBidirectionalManyToOneRegular() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        SalesForce force = new SalesForce();
        force.setCorporation("Red Hat");
        session.save((Object)force);
        SalesGuy eric = new SalesGuy();
        eric.setName("Eric");
        eric.setSalesForce(force);
        force.getSalesGuys().add(eric);
        session.save((Object)eric);
        SalesGuy simon = new SalesGuy();
        simon.setName("Simon");
        simon.setSalesForce(force);
        force.getSalesGuys().add(simon);
        session.save((Object)simon);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        force = (SalesForce)session.get(SalesForce.class, (Serializable)((Object)force.getId()));
        ManyToOneTest.assertNotNull(force.getSalesGuys());
        ManyToOneTest.assertEquals((int)2, (int)force.getSalesGuys().size());
        simon = (SalesGuy)session.get(SalesGuy.class, (Serializable)((Object)simon.getId()));
        session.delete((Object)simon);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        force = (SalesForce)session.get(SalesForce.class, (Serializable)((Object)force.getId()));
        ManyToOneTest.assertNotNull(force.getSalesGuys());
        ManyToOneTest.assertEquals((int)1, (int)force.getSalesGuys().size());
        session.delete((Object)force.getSalesGuys().iterator().next());
        session.delete((Object)force);
        transaction.commit();
        session.close();
        this.checkCleanCache();
    }

    public void testBiDirManyToOneInsertUpdateFalse() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        Beer hoegaarden = new Beer();
        Brewery hoeBrewery = new Brewery();
        hoeBrewery.getBeers().add(hoegaarden);
        hoegaarden.setBrewery(hoeBrewery);
        session.persist((Object)hoeBrewery);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        hoegaarden = TestHelper.get(session, Beer.class, (Serializable)((Object)hoegaarden.getId()));
        Assertions.assertThat((Object)hoegaarden).isNotNull();
        Assertions.assertThat((Object)hoegaarden.getBrewery()).isNotNull();
        ((CollectionAssert)Assertions.assertThat(hoegaarden.getBrewery().getBeers()).hasSize(1)).containsOnly(new Object[]{hoegaarden});
        Beer citron = new Beer();
        hoeBrewery = hoegaarden.getBrewery();
        hoeBrewery.getBeers().remove(hoegaarden);
        hoeBrewery.getBeers().add(citron);
        citron.setBrewery(hoeBrewery);
        session.delete((Object)hoegaarden);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        citron = TestHelper.get(session, Beer.class, (Serializable)((Object)citron.getId()));
        ((CollectionAssert)Assertions.assertThat(citron.getBrewery().getBeers()).hasSize(1)).containsOnly(new Object[]{citron});
        hoeBrewery = citron.getBrewery();
        citron.setBrewery(null);
        hoeBrewery.getBeers().clear();
        session.delete((Object)citron);
        session.delete((Object)hoeBrewery);
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{JUG.class, Member.class, SalesForce.class, SalesGuy.class, Beer.class, Brewery.class};
    }
}

