/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.associations.collection.unidirectional;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.test.associations.collection.unidirectional.Cloud;
import org.hibernate.ogm.test.associations.collection.unidirectional.SnowFlake;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;
import org.hibernate.ogm.test.utils.TestHelper;

public class CollectionUnidirectionalTest
extends OgmTestCase {
    public void testUnidirectionalCollection() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        SnowFlake sf = new SnowFlake();
        sf.setDescription("Snowflake 1");
        session.save((Object)sf);
        SnowFlake sf2 = new SnowFlake();
        sf2.setDescription("Snowflake 2");
        session.save((Object)sf2);
        Cloud cloud = new Cloud();
        cloud.setLength(23.0);
        cloud.getProducedSnowFlakes().add(sf);
        cloud.getProducedSnowFlakes().add(sf2);
        session.persist((Object)cloud);
        session.flush();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(3, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(1, this.sessions)).isTrue();
        transaction.commit();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(3, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(1, this.sessions)).isTrue();
        session.clear();
        transaction = session.beginTransaction();
        cloud = (Cloud)session.get(Cloud.class, (Serializable)((Object)cloud.getId()));
        CollectionUnidirectionalTest.assertNotNull(cloud.getProducedSnowFlakes());
        CollectionUnidirectionalTest.assertEquals((int)2, (int)cloud.getProducedSnowFlakes().size());
        SnowFlake removedSf = cloud.getProducedSnowFlakes().iterator().next();
        SnowFlake sf3 = new SnowFlake();
        sf3.setDescription("Snowflake 3");
        session.persist((Object)sf3);
        cloud.getProducedSnowFlakes().remove(removedSf);
        cloud.getProducedSnowFlakes().add(sf3);
        transaction.commit();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(4, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(1, this.sessions)).isTrue();
        session.clear();
        transaction = session.beginTransaction();
        cloud = (Cloud)session.get(Cloud.class, (Serializable)((Object)cloud.getId()));
        CollectionUnidirectionalTest.assertNotNull(cloud.getProducedSnowFlakes());
        CollectionUnidirectionalTest.assertEquals((int)2, (int)cloud.getProducedSnowFlakes().size());
        boolean present = false;
        for (SnowFlake current : cloud.getProducedSnowFlakes()) {
            if (!current.getDescription().equals(removedSf.getDescription())) continue;
            present = true;
        }
        CollectionUnidirectionalTest.assertFalse((String)"flake not removed", (boolean)present);
        for (SnowFlake current : cloud.getProducedSnowFlakes()) {
            session.delete((Object)current);
        }
        session.delete(session.load(SnowFlake.class, (Serializable)((Object)removedSf.getId())));
        cloud.getProducedSnowFlakes().clear();
        transaction.commit();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(1, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(0, this.sessions)).isTrue();
        session.clear();
        transaction = session.beginTransaction();
        cloud = (Cloud)session.get(Cloud.class, (Serializable)((Object)cloud.getId()));
        CollectionUnidirectionalTest.assertNotNull(cloud.getProducedSnowFlakes());
        CollectionUnidirectionalTest.assertEquals((int)0, (int)cloud.getProducedSnowFlakes().size());
        session.delete((Object)cloud);
        session.flush();
        transaction.commit();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(0, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(0, this.sessions)).isTrue();
        session.close();
        this.checkCleanCache();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Cloud.class, SnowFlake.class};
    }
}

