/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.associations.collection.types;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.test.associations.collection.types.Child;
import org.hibernate.ogm.test.associations.collection.types.Father;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;

public class ListTest
extends OgmTestCase {
    public void testOrderedList() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        Child luke = new Child();
        luke.setName("Luke");
        Child leia = new Child();
        leia.setName("Leia");
        session.persist((Object)luke);
        session.persist((Object)leia);
        Father father = new Father();
        father.getOrderedChildren().add(luke);
        father.getOrderedChildren().add(null);
        father.getOrderedChildren().add(leia);
        session.persist((Object)father);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        father = (Father)session.get(Father.class, (Serializable)((Object)father.getId()));
        ((ListAssert)Assertions.assertThat(father.getOrderedChildren()).as("List should have 3 elements")).hasSize(3);
        ((StringAssert)Assertions.assertThat((String)father.getOrderedChildren().get(0).getName()).as("Luke should be first")).isEqualTo((Object)luke.getName());
        ((ObjectAssert)Assertions.assertThat((Object)father.getOrderedChildren().get(1)).as("Second born should be null")).isNull();
        ((StringAssert)Assertions.assertThat((String)father.getOrderedChildren().get(2).getName()).as("Leia should be third")).isEqualTo((Object)leia.getName());
        session.delete((Object)father);
        session.delete(session.load(Child.class, (Serializable)((Object)luke.getId())));
        session.delete(session.load(Child.class, (Serializable)((Object)leia.getId())));
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Father.class, Child.class};
    }
}

