/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.associations.collection.manytomany;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.test.associations.collection.manytomany.AccountOwner;
import org.hibernate.ogm.test.associations.collection.manytomany.BankAccount;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;
import org.hibernate.ogm.test.utils.TestHelper;

public class ManyToManyTest
extends OgmTestCase {
    public void testManyToMany() {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        AccountOwner owner = new AccountOwner();
        owner.setSSN("0123456");
        BankAccount soge = new BankAccount();
        soge.setAccountNumber("X2345000");
        owner.getBankAccounts().add(soge);
        soge.getOwners().add(owner);
        session.persist((Object)owner);
        tx.commit();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(2, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(2, this.sessions)).isTrue();
        session.clear();
        tx = session.beginTransaction();
        soge = TestHelper.get(session, BankAccount.class, (Serializable)((Object)soge.getId()));
        Assertions.assertThat(soge.getOwners()).hasSize(1);
        Assertions.assertThat(soge.getOwners()).onProperty("id").contains(new Object[]{owner.getId()});
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        owner = TestHelper.get(session, AccountOwner.class, (Serializable)((Object)owner.getId()));
        Assertions.assertThat(owner.getBankAccounts()).hasSize(1);
        Assertions.assertThat(owner.getBankAccounts()).onProperty("id").contains(new Object[]{soge.getId()});
        BankAccount barclays = new BankAccount();
        barclays.setAccountNumber("ZZZ-009");
        barclays.getOwners().add(owner);
        soge = owner.getBankAccounts().iterator().next();
        soge.getOwners().remove(owner);
        owner.getBankAccounts().add(barclays);
        owner.getBankAccounts().remove(soge);
        session.delete((Object)soge);
        tx.commit();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(2, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(2, this.sessions)).isTrue();
        session.clear();
        tx = session.beginTransaction();
        owner = TestHelper.get(session, AccountOwner.class, (Serializable)((Object)owner.getId()));
        Assertions.assertThat(owner.getBankAccounts()).hasSize(1);
        Assertions.assertThat(owner.getBankAccounts()).onProperty("id").contains(new Object[]{barclays.getId()});
        barclays = owner.getBankAccounts().iterator().next();
        barclays.getOwners().clear();
        owner.getBankAccounts().clear();
        session.delete((Object)barclays);
        session.delete((Object)owner);
        tx.commit();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(0, this.sessions)).isTrue();
        Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(0, this.sessions)).isTrue();
        session.close();
        this.checkCleanCache();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{AccountOwner.class, BankAccount.class};
    }
}

