/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl.predicate.impl;

import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;
import org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl.InfinispanRemoteQueryBuilder;

public class InfinispanRemoteComparisonPredicate
extends ComparisonPredicate<InfinispanRemoteQueryBuilder>
implements NegatablePredicate<InfinispanRemoteQueryBuilder> {
    public InfinispanRemoteComparisonPredicate(String propertyName, ComparisonPredicate.Type comparisonType, Object value) {
        super(propertyName, comparisonType, value);
    }

    protected InfinispanRemoteQueryBuilder getStrictlyLessQuery() {
        return this.comparison(" < ");
    }

    protected InfinispanRemoteQueryBuilder getLessOrEqualsQuery() {
        return this.comparison(" <= ");
    }

    protected InfinispanRemoteQueryBuilder getEqualsQuery() {
        return this.comparison(" = ");
    }

    private InfinispanRemoteQueryBuilder getNotEqualsQuery() {
        return this.comparison(" <> ");
    }

    protected InfinispanRemoteQueryBuilder getGreaterOrEqualsQuery() {
        return this.comparison(" >= ");
    }

    protected InfinispanRemoteQueryBuilder getStrictlyGreaterQuery() {
        return this.comparison(" > ");
    }

    public InfinispanRemoteQueryBuilder getNegatedQuery() {
        switch (this.type) {
            case LESS: {
                return this.getGreaterOrEqualsQuery();
            }
            case LESS_OR_EQUAL: {
                return this.getStrictlyGreaterQuery();
            }
            case EQUALS: {
                return this.getNotEqualsQuery();
            }
            case GREATER_OR_EQUAL: {
                return this.getStrictlyLessQuery();
            }
            case GREATER: {
                return this.getLessOrEqualsQuery();
            }
        }
        throw new UnsupportedOperationException("Unsupported comparison type: " + this.type);
    }

    private InfinispanRemoteQueryBuilder comparison(String operator) {
        InfinispanRemoteQueryBuilder builder = new InfinispanRemoteQueryBuilder(this.propertyName);
        builder.append(operator);
        builder.appendValue(this.value);
        return builder;
    }
}

