/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl.InfinispanRemotePredicateFactory;
import org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl.InfinispanRemotePropertyHelper;
import org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl.InfinispanRemoteQueryBuilder;
import org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl.InfinispanRemoteQueryParameter;
import org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl.InfinispanRemoteQueryParsingResult;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.query.parsing.impl.KeepNamedParametersQueryRendererDelegate;

public class InfinispanRemoteQueryRendererDelegate
extends KeepNamedParametersQueryRendererDelegate<InfinispanRemoteQueryBuilder, InfinispanRemoteQueryParsingResult> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final SessionFactoryImplementor sessionFactory;
    private InfinispanRemoteQueryBuilder sortClause;

    public InfinispanRemoteQueryRendererDelegate(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames, InfinispanRemotePropertyHelper propertyHelper, Map<String, Object> namedParameters) {
        super((PropertyHelper)propertyHelper, entityNames, InfinispanRemoteQueryRendererDelegate.getSingleEntityQueryBuilder(sessionFactory, propertyHelper), namedParameters);
        this.sessionFactory = sessionFactory;
    }

    private static SingleEntityQueryBuilder<InfinispanRemoteQueryBuilder> getSingleEntityQueryBuilder(SessionFactoryImplementor sessionFactory, InfinispanRemotePropertyHelper propertyHelper) {
        return SingleEntityQueryBuilder.getInstance((PredicateFactory)new InfinispanRemotePredicateFactory(sessionFactory, propertyHelper), (PropertyHelper)propertyHelper);
    }

    public InfinispanRemoteQueryParsingResult getResult() {
        InfinispanRemoteQueryBuilder queryBuilder;
        OgmEntityPersister ogmEntityPersister = (OgmEntityPersister)this.sessionFactory.getMetamodel().entityPersister(this.targetTypeName);
        String table = ogmEntityPersister.getEntityKeyMetadata().getTable();
        if (this.projections.isEmpty()) {
            queryBuilder = (InfinispanRemoteQueryBuilder)this.builder.build();
        } else {
            queryBuilder = this.createFromProjection();
            queryBuilder.append((InfinispanRemoteQueryBuilder)this.builder.build());
        }
        this.applyInheritanceStrategy(ogmEntityPersister, queryBuilder);
        if (this.sortClause != null) {
            queryBuilder.append(this.sortClause);
        }
        return new InfinispanRemoteQueryParsingResult(queryBuilder, table, this.projections);
    }

    private void applyInheritanceStrategy(OgmEntityPersister entityPersister, InfinispanRemoteQueryBuilder queryBuilder) {
        String discriminatorColumnName = entityPersister.getDiscriminatorColumnName();
        if (discriminatorColumnName != null) {
            this.addConditionOnDiscriminatorValue(entityPersister, queryBuilder, discriminatorColumnName);
        } else if (entityPersister.hasSubclasses()) {
            Set subclassEntityNames = entityPersister.getEntityMetamodel().getSubclassEntityNames();
            throw LOG.queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass("Infinispan Server", subclassEntityNames);
        }
    }

    private void addConditionOnDiscriminatorValue(OgmEntityPersister entityPersister, InfinispanRemoteQueryBuilder queryBuilder, String discriminatorColumnName) {
        Object discriminatorValue = entityPersister.getDiscriminatorValue();
        Set subclassEntityNames = entityPersister.getEntityMetamodel().getSubclassEntityNames();
        if (queryBuilder.hasWhere()) {
            queryBuilder.append(" and ");
        } else {
            queryBuilder.append(" where ");
        }
        queryBuilder.append(discriminatorColumnName);
        if (subclassEntityNames.size() == 1) {
            queryBuilder.append(" = ");
            queryBuilder.appendValue(discriminatorValue);
        } else {
            ArrayList<Object> discriminatorValues = new ArrayList<Object>();
            for (String subclass : subclassEntityNames) {
                OgmEntityPersister subclassPersister = (OgmEntityPersister)this.sessionFactory.getMetamodel().entityPersister(subclass);
                discriminatorValues.add(subclassPersister.getDiscriminatorValue());
            }
            queryBuilder.append(" in (");
            queryBuilder.appendValues(discriminatorValues);
            queryBuilder.append(")");
        }
    }

    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            PathedPropertyReferenceSource last = propertyPath.getLastNode();
            if (!last.isAlias()) {
                String columnName = this.getColumnName(propertyPath);
                this.projections.add(columnName);
            }
        } else {
            this.propertyPath = propertyPath;
        }
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        String columnName = this.getColumnName(propertyPath);
        if (this.sortClause == null) {
            this.sortClause = new InfinispanRemoteQueryBuilder(" order by ");
        } else {
            this.sortClause.append(", ");
        }
        this.appendSortField(isAscending, columnName);
    }

    private String getColumnName(PropertyPath propertyPath) {
        return ((InfinispanRemotePropertyHelper)this.propertyHelper).getColumnName(this.targetTypeName, propertyPath.getNodeNamesWithoutAlias());
    }

    private void appendSortField(boolean isAscending, String columnName) {
        this.sortClause.append(columnName);
        if (isAscending) {
            this.sortClause.append(" asc");
        } else {
            this.sortClause.append(" desc");
        }
    }

    private InfinispanRemoteQueryBuilder createFromProjection() {
        InfinispanRemoteQueryBuilder builder = new InfinispanRemoteQueryBuilder("select ");
        builder.appendStrings(this.projections);
        builder.append(" ");
        return builder;
    }

    protected Object getObjectParameter(String comparativePredicate) {
        return new InfinispanRemoteQueryParameter(comparativePredicate.substring(1));
    }
}

