/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl.InfinispanRemoteQueryParameter;
import org.hibernate.ogm.query.parsing.impl.ParserPropertyHelper;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class InfinispanRemotePropertyHelper
extends ParserPropertyHelper {
    private final SessionFactoryImplementor sessionFactory;

    public InfinispanRemotePropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames) {
        super(sessionFactory, entityNames);
        this.sessionFactory = sessionFactory;
    }

    public String getColumnName(String entityType, List<String> propertyPath) {
        return this.getColumn(this.getPersister(entityType), propertyPath);
    }

    protected Type getPropertyType(String entityType, List<String> propertyPath) {
        Type propertyType = super.getPropertyType(entityType, propertyPath);
        if (this.isElementCollection(propertyType)) {
            return ((CollectionType)propertyType).getElementType(this.sessionFactory);
        }
        return propertyType;
    }

    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        if (value instanceof InfinispanRemoteQueryParameter) {
            return value;
        }
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        if (this.isElementCollection(propertyType)) {
            propertyType = ((CollectionType)propertyType).getElementType(this.sessionFactory);
        }
        GridType ogmType = ((TypeTranslator)this.sessionFactory.getServiceRegistry().getService(TypeTranslator.class)).getType(propertyType);
        return ogmType.convertToBackendType(value, this.sessionFactory);
    }
}

