/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.schema.SchemaDefinitions;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SequenceTableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.TableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispanremote.schema.spi.SchemaOverride;
import org.hibernate.ogm.util.impl.ResourceHelper;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.FileDescriptor;

public class SchemaValidator {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final SchemaDefinitions owner;
    private final String schemaName;
    private final String protoSchema;

    public SchemaValidator(SchemaDefinitions owner, SchemaOverride schemaOverrideService, URL schemaOverrideResource, String schemaName) {
        this.owner = owner;
        this.schemaName = schemaName;
        if (schemaOverrideService != null) {
            this.protoSchema = schemaOverrideService.createProtobufSchema();
        } else if (schemaOverrideResource != null) {
            this.protoSchema = this.readProtoSchema(schemaOverrideResource);
        } else {
            throw new HibernateException("SchemaValidator#init needs at least one of schemaOverrideService or schemaOverrideResource");
        }
        this.validate();
    }

    private String readProtoSchema(URL schemaOverrideResource) {
        try {
            return ResourceHelper.readResource((URL)schemaOverrideResource);
        }
        catch (IOException e) {
            throw LOG.errorLoadingSchemaOverrideResourceFile(schemaOverrideResource);
        }
    }

    public String provideSchema() {
        return this.protoSchema;
    }

    private void validate() {
        FileDescriptor fileDescriptor;
        try {
            fileDescriptor = this.parseSchema();
        }
        catch (IOException | DescriptorParserException e) {
            throw LOG.providedSchemaHasAnIllegalFormat(e.getMessage(), this.protoSchema);
        }
        if (!this.owner.packageName.equals(fileDescriptor.getPackage())) {
            throw LOG.providedSchemaHasAnInvalidPackageName(this.owner.packageName, fileDescriptor.getPackage());
        }
        for (SequenceTableDefinition sequenceTableDefinition : this.owner.idSchemaPerMetadata.values()) {
            if (sequenceTableDefinition.isDescribedIn(fileDescriptor)) continue;
            throw LOG.providedSchemaHasAnInvalidCacheDefinition(sequenceTableDefinition.getName());
        }
        for (TableDefinition tableDefinition : this.owner.definitionsByTableName.values()) {
            if (tableDefinition.isDescribedIn(fileDescriptor)) continue;
            throw LOG.providedSchemaHasAnInvalidCacheDefinition(tableDefinition.getTableName());
        }
    }

    private FileDescriptor parseSchema() throws DescriptorParserException, IOException {
        FileDescriptorSource fileDescriptorSource = FileDescriptorSource.fromString((String)this.schemaName, (String)this.protoSchema);
        Configuration config = Configuration.builder().build();
        SerializationContext serCtx = ProtobufUtil.newSerializationContext((Configuration)config);
        serCtx.registerProtoFiles(fileDescriptorSource);
        return (FileDescriptor)serCtx.getFileDescriptors().get(this.schemaName);
    }
}

