/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.counter;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.impl.counter.CounterHandler;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SequenceTableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.HotRodSequenceHandler;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public class HotRodSequenceCounterHandler
extends HotRodSequenceHandler {
    private Map<String, CounterHandler> sequenceHandlers = new HashMap<String, CounterHandler>();

    public HotRodSequenceCounterHandler(InfinispanRemoteDatastoreProvider owner, OgmProtoStreamMarshaller marshaller, Map<String, SequenceTableDefinition> idSchemaPerName, Set<Sequence> sequences) {
        super(owner, marshaller, idSchemaPerName);
        for (Sequence sequence : sequences) {
            CounterHandler handler = new CounterHandler(owner.getManager(), sequence);
            this.sequenceHandlers.put(handler.getCounterName(), handler);
        }
    }

    @Override
    public Number getSequenceValue(NextValueRequest request) {
        IdSourceKey idSourceKey = request.getKey();
        if (this.isSequenceGeneratorId(idSourceKey)) {
            return this.sequenceHandlers.get(idSourceKey.getTable()).nextValue(request);
        }
        return super.getSequenceValue(request);
    }

    private boolean isSequenceGeneratorId(IdSourceKey idSourceKey) {
        return HotRodSequenceCounterHandler.isSequenceGeneratorId(idSourceKey.getMetadata());
    }

    public static boolean isSequenceGeneratorId(IdSourceKeyMetadata idSourceKeyMetadata) {
        return IdSourceKeyMetadata.IdSourceType.SEQUENCE.equals((Object)idSourceKeyMetadata.getType());
    }
}

