/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.storedprocedure.ProcedureQueryParameters;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.TupleExtractor;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;

public class InfinispanRemoteStoredProceduresManager {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final Pattern REFERENCE_ERROR_REGEXP = Pattern.compile(".*\"([a-zA-Z_$]+)\" is not defined in <eval>.*");
    private static final String UNKNOWN_TASK_ERROR_ID = "ISPN027002";

    public ClosableIterator<Tuple> callStoredProcedure(InfinispanRemoteDatastoreProvider provider, String storedProcedureName, ProcedureQueryParameters queryParameters) {
        this.validate(queryParameters);
        RemoteCache executor = provider.getScriptExecutorCache();
        Object res = this.execute(executor, storedProcedureName, queryParameters);
        return this.extractResultSet(storedProcedureName, res);
    }

    private void validate(ProcedureQueryParameters queryParameters) {
        List positionalParameters = queryParameters.getPositionalParameters();
        if (positionalParameters != null && positionalParameters.size() > 0) {
            throw log.dialectDoesNotSupportPositionalParametersForStoredProcedures(this.getClass());
        }
    }

    private Object execute(RemoteCache<Object, Object> executor, String storedProcedureName, ProcedureQueryParameters queryParameters) {
        Map namedParameters = queryParameters.getNamedParameters();
        try {
            return executor.execute(storedProcedureName, namedParameters);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e instanceof HotRodClientException && msg != null) {
                String param;
                if (msg.contains(UNKNOWN_TASK_ERROR_ID)) {
                    throw log.procedureWithResolvedNameDoesNotExist(storedProcedureName, e);
                }
                Matcher matcher = REFERENCE_ERROR_REGEXP.matcher(msg);
                if (matcher.find() && (param = matcher.group(1)) != null && !param.isEmpty()) {
                    throw log.cannotSetStoredProcedureParameter(storedProcedureName, param, namedParameters.get(param), e);
                }
            }
            throw log.cannotExecuteStoredProcedure(storedProcedureName, e);
        }
    }

    private ClosableIterator<Tuple> extractResultSet(String storedProcedureName, Object res) {
        try {
            return CollectionHelper.newClosableIterator((Iterable)TupleExtractor.extractTuplesFromObject((Object)res));
        }
        catch (Exception e) {
            throw log.cannotExtractStoredProcedureResultSet(storedProcedureName, res, e);
        }
    }
}

