/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.ogm.backendtck.storedprocedures.Car;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.test.storedprocedures.ExceptionalProcedure;
import org.hibernate.ogm.datastore.infinispanremote.test.storedprocedures.ResultSetProcedure;
import org.hibernate.ogm.datastore.infinispanremote.test.storedprocedures.SimpleValueProcedure;
import org.hibernate.ogm.datastore.infinispanremote.utils.InfinispanRemoteTestHelper;
import org.hibernate.ogm.util.impl.ResourceHelper;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.tasks.ServerTask;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class StoredProceduresDeployer {
    private static final String FOLDER_SEP = System.getProperty("file.separator");
    private static final String INFINISPAN_DEPLOYMENTS_DIRECTORY = "target/infinispan-server/standalone/deployments/".replaceAll("//", FOLDER_SEP);
    private static final int MAX_WAIT_MILLISECONDS = 20000;
    private static final int STATE_REFRESH_MILLISECONDS = 500;
    private static final int MAX_STATE_REFRESH_ATTEMPTS = 40;

    public static void deployJavaScripts(SessionFactory sessionFactory) {
        InfinispanRemoteDatastoreProvider provider = InfinispanRemoteTestHelper.getProvider(sessionFactory);
        RemoteCache scriptCache = provider.getScriptCache();
        scriptCache.put((Object)"simpleValueProcedure", (Object)StoredProceduresDeployer.script("/storedprocedures/simpleValueProcedure.js"));
        scriptCache.put((Object)"resultSetProcedure", (Object)StoredProceduresDeployer.script("/storedprocedures/resultSetProcedure.js"));
        scriptCache.put((Object)"exceptionalProcedure", (Object)StoredProceduresDeployer.script("/storedprocedures/exceptionalProcedure.js"));
    }

    public static void undeployJavaScripts(SessionFactory sessionFactory) {
        InfinispanRemoteDatastoreProvider provider = InfinispanRemoteTestHelper.getProvider(sessionFactory);
        RemoteCache scriptCache = provider.getScriptCache();
        scriptCache.remove((Object)"simpleValueProcedure");
        scriptCache.remove((Object)"resultSetProcedure");
        scriptCache.remove((Object)"exceptionalProcedure");
    }

    public static void deployJars() throws InterruptedException {
        JavaArchive simpleValueJar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"simple-value-procedure.jar")).addClass(SimpleValueProcedure.class)).addAsServiceProvider(ServerTask.class, new Class[]{SimpleValueProcedure.class});
        JavaArchive resultSetJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"result-set-procedure.jar")).addClass(Car.class)).addClass(ResultSetProcedure.class)).addAsServiceProvider(ServerTask.class, new Class[]{ResultSetProcedure.class});
        JavaArchive exceptionalProcedureJar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"exceptional-procedure.jar")).addClass(ExceptionalProcedure.class)).addAsServiceProvider(ServerTask.class, new Class[]{ExceptionalProcedure.class});
        StoredProceduresDeployer.deploy(new Archive[]{simpleValueJar, exceptionalProcedureJar, resultSetJar});
    }

    private static void deploy(Archive<?> ... archives) {
        for (Archive<?> archive : archives) {
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(StoredProceduresDeployer.deploymentDirectory(archive.getName()), true);
        }
        StoredProceduresDeployer.waitForArchivesDeployment(archives);
    }

    private static File deploymentDirectory(String name) {
        return new File(INFINISPAN_DEPLOYMENTS_DIRECTORY + name);
    }

    private static void waitForArchivesDeployment(Archive<?> ... archives) {
        for (int attempts = 0; attempts < 40; ++attempts) {
            if (StoredProceduresDeployer.hasDeployed(archives)) {
                return;
            }
            StoredProceduresDeployer.waitOrAbort();
        }
        throw new RuntimeException("Stored procedures not deployed");
    }

    private static void waitOrAbort() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for Hot Rod server to deploy the stored procedures");
        }
    }

    private static boolean hasDeployed(Archive<?> ... archives) {
        for (Archive<?> archive : archives) {
            if (Files.exists(Paths.get(INFINISPAN_DEPLOYMENTS_DIRECTORY + archive.getName() + ".deployed", new String[0]), new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    private static String script(String path) {
        try {
            return ResourceHelper.readResource((URL)StoredProceduresDeployer.class.getResource(path));
        }
        catch (IOException e) {
            throw new HibernateException((Throwable)e);
        }
    }
}

