/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.utils;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.junit.rules.ExternalResource;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.StandaloneCommandBuilder;

public final class RemoteHotRodServerRule
extends ExternalResource {
    private static final int MAX_WAIT_MILLISECONDS = 120000;
    private static final int STATE_REFRESH_MILLISECONDS = 50;
    private static final int MAX_STATE_REFRESH_ATTEMPTS = 2400;
    private static final String DEFAULT_CONFIG_PATH = "wildfly-trimmed-config.xml";
    private static final AtomicBoolean running = new AtomicBoolean();
    private final int portOffset;
    private Process hotRodServer;

    public RemoteHotRodServerRule() {
        this.portOffset = 0;
    }

    public RemoteHotRodServerRule(int portOffset) {
        this.portOffset = portOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before() throws Exception {
        AtomicBoolean atomicBoolean = running;
        synchronized (atomicBoolean) {
            if (running.compareAndSet(false, true)) {
                StandaloneCommandBuilder builder = StandaloneCommandBuilder.of((String)"target/infinispan-server");
                builder.setServerReadOnlyConfiguration(DEFAULT_CONFIG_PATH);
                if (this.portOffset != 0) {
                    builder.addJavaOption("-Djboss.socket.binding.port-offset=" + this.portOffset);
                }
                Launcher launcher = Launcher.of((CommandBuilder)builder);
                this.hotRodServer = launcher.launch();
                this.waitForRunning();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after() {
        AtomicBoolean atomicBoolean = running;
        synchronized (atomicBoolean) {
            if (this.hotRodServer != null) {
                running.set(false);
                this.hotRodServer.destroyForcibly();
                RemoteHotRodServerRule.messageOut("Server Killed");
            }
        }
    }

    public void waitForRunning() throws Exception {
        try (ModelControllerClient client = ModelControllerClient.Factory.create((String)"localhost", (int)(9990 + this.portOffset));){
            this.waitForServerBoot(client);
            this.waitForCacheManagerBoot(client);
        }
    }

    private void waitForServerBoot(ModelControllerClient client) {
        for (int attempts = 0; attempts < 2400; ++attempts) {
            if (this.isServerInRunningState(client)) {
                RemoteHotRodServerRule.messageOut("Server is now running");
                return;
            }
            this.waitOrAbort();
        }
        this.timedOut();
    }

    private void waitForCacheManagerBoot(ModelControllerClient client) {
        for (int attempts = 0; attempts < 2400; ++attempts) {
            if (this.isCacheExists(client)) {
                RemoteHotRodServerRule.messageOut("CacheManager is now running");
                return;
            }
            this.waitOrAbort();
        }
        this.timedOut();
    }

    private void waitOrAbort() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for Hot Rod server to have booted successfully");
        }
    }

    private void timedOut() {
        throw new RuntimeException("Timed out while waiting for Hot Rod server to have booted successfully");
    }

    private boolean isServerInRunningState(ModelControllerClient client) {
        try {
            ModelNode op = new ModelNode();
            op.get("operation").set("read-attribute");
            op.get("address").setEmptyList();
            op.get("name").set("server-state");
            ModelNode rsp = client.execute(op);
            return "success".equals(rsp.get("outcome").asString()) && !"starting".equals(rsp.get("result").asString()) && !"stopping".equals(rsp.get("result").asString());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean isCacheExists(ModelControllerClient client) {
        try {
            PathAddress pathAddress = PathAddress.pathAddress((String)"subsystem", (String)"datagrid-infinispan").append("cache-container", "clustered");
            ModelNode op = new ModelNode();
            op.get("operation").set("read-attribute");
            op.get("address").set(pathAddress.toModelNode());
            op.get("name").set("cache-manager-status");
            ModelNode resp = client.execute(op);
            return "success".equals(resp.get("outcome").asString()) && "RUNNING".equals(resp.get("result").asString());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        RemoteHotRodServerRule rule = new RemoteHotRodServerRule();
        rule.before();
        rule.after();
    }

    private static void messageOut(String msg) {
        System.out.println("\n***\tTest client helper: " + msg + "\t***\n");
    }
}

