/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.sequences;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.HotRodSequencer;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.SequenceId;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.infinispan.client.hotrod.RemoteCache;

public class SequencesPerCache {
    private final RemoteCache<SequenceId, Long> remoteCache;
    private final ConcurrentMap<IdSourceKey, HotRodSequencer> sequencers = new ConcurrentHashMap<IdSourceKey, HotRodSequencer>();

    SequencesPerCache(RemoteCache<SequenceId, Long> remoteCache) {
        this.remoteCache = Objects.requireNonNull(remoteCache);
    }

    public Number getSequenceValue(NextValueRequest request) {
        IdSourceKey key = request.getKey();
        HotRodSequencer sequencer = this.sequencers.computeIfAbsent(key, v -> new HotRodSequencer(this.remoteCache, request));
        return sequencer.getSequenceValue(request);
    }
}

