/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.schema;

import java.io.IOException;
import java.util.List;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.LongProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.StringProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.ProtobufEntryExporter;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SanitationUtils;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.SequenceId;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;

public final class SequenceTableDefinition
implements ProtobufEntryExporter {
    private final String messageName;
    private final String idMessageName;
    private final String keyColumnName;
    private final String valueColumnName;
    private final LongProtofieldAccessor valueEncoder;
    private final StringProtofieldAccessor sequenceNameEncoder;
    private final String protobufPackageName;

    public SequenceTableDefinition(IdSourceKeyMetadata idSourceKeyMetadata, String protobufPackageName) {
        this.protobufPackageName = protobufPackageName;
        this.messageName = SequenceTableDefinition.inferMessageName(idSourceKeyMetadata);
        this.idMessageName = SanitationUtils.toProtobufIdName(this.messageName);
        this.keyColumnName = SanitationUtils.convertNameSafely(idSourceKeyMetadata.getKeyColumnName());
        this.valueColumnName = SanitationUtils.convertNameSafely(idSourceKeyMetadata.getValueColumnName());
        this.sequenceNameEncoder = new StringProtofieldAccessor(1, this.keyColumnName, false, idSourceKeyMetadata.getKeyColumnName());
        this.valueEncoder = new LongProtofieldAccessor(2, this.valueColumnName, false, idSourceKeyMetadata.getValueColumnName());
    }

    private static String inferMessageName(IdSourceKeyMetadata idSourceKeyMetadata) {
        return SanitationUtils.convertNameSafely(idSourceKeyMetadata.getName());
    }

    @Override
    public void exportProtobufEntry(StringBuilder sb) {
        SequenceTableDefinition.exportMessage(this.idMessageName, this.sequenceNameEncoder, sb);
        SequenceTableDefinition.exportMessage(this.messageName, this.valueEncoder, sb);
    }

    private static void exportMessage(String messageName, ProtofieldAccessor<?> encoder, StringBuilder sb) {
        sb.append("\nmessage ").append(messageName).append(" {");
        encoder.exportProtobufFieldDefinition(sb);
        sb.append("\n}\n");
    }

    public String getName() {
        return this.messageName;
    }

    public SequenceId readSequenceId(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        String read = (String)this.sequenceNameEncoder.read(reader);
        return new SequenceId(read);
    }

    public void writeSequenceId(MessageMarshaller.ProtoStreamWriter writer, SequenceId t) throws IOException {
        this.sequenceNameEncoder.writeTo(writer, t.getSegmentName());
    }

    public String getQualifiedIdMessageName() {
        return SanitationUtils.qualify(this.idMessageName, this.protobufPackageName);
    }

    public boolean isDescribedIn(FileDescriptor fileDescriptor) {
        boolean idMessageIsDescribed = false;
        boolean messageIsDescribed = false;
        for (Descriptor descriptor : fileDescriptor.getMessageTypes()) {
            if (descriptor.getName().equals(this.idMessageName) && this.idMessageIsDescribedIn(descriptor)) {
                idMessageIsDescribed = true;
            }
            if (!descriptor.getName().equals(this.messageName) || !this.messageIsDescribedIn(descriptor)) continue;
            messageIsDescribed = true;
        }
        return idMessageIsDescribed && messageIsDescribed;
    }

    private boolean idMessageIsDescribedIn(Descriptor descriptor) {
        List fields = descriptor.getFields();
        if (fields.size() != 1) {
            return false;
        }
        FieldDescriptor fieldDescriptor = (FieldDescriptor)fields.get(0);
        return fieldDescriptor.getName().equals(this.keyColumnName) || !fieldDescriptor.getTypeName().equals(this.sequenceNameEncoder.getProtobufTypeName());
    }

    private boolean messageIsDescribedIn(Descriptor descriptor) {
        List fields = descriptor.getFields();
        if (fields.size() != 1) {
            return false;
        }
        FieldDescriptor fieldDescriptor = (FieldDescriptor)fields.get(0);
        return fieldDescriptor.getName().equals(this.valueColumnName) || !fieldDescriptor.getTypeName().equals(this.valueEncoder.getProtobufTypeName());
    }
}

