/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protostream.multimessage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.multimessage.MultiMessage;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;

public class MultiMessageExtension {
    public static byte[] toWrappedByteArray(ImmutableSerializationContext ctx, MultiMessage t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MultiMessageExtension.writeMessage(ctx, RawProtoStreamWriterImpl.newInstance((OutputStream)baos), t);
        return baos.toByteArray();
    }

    private static void writeMessage(ImmutableSerializationContext ctx, RawProtoStreamWriter out, MultiMessage t) throws IOException {
        if (t == null) {
            return;
        }
        BaseMarshallerDelegate marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(t.getMessageType());
        ByteArrayOutputStreamEx buffer = new ByteArrayOutputStreamEx();
        RawProtoStreamWriter nestedOut = RawProtoStreamWriterImpl.newInstance((OutputStream)buffer);
        marshallerDelegate.marshall(null, (Object)t, null, nestedOut);
        nestedOut.flush();
        String typeName = marshallerDelegate.getMarshaller().getTypeName();
        Integer typeId = ctx.getTypeIdByName(typeName);
        if (typeId == null) {
            out.writeString(16, typeName);
        } else {
            out.writeInt32(19, typeId.intValue());
        }
        out.writeBytes(17, buffer.getByteBuffer());
        out.flush();
    }
}

