/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.counter;

import java.util.concurrent.ExecutionException;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.api.StrongCounter;

public class CounterHandler {
    private final String counterName;
    private final StrongCounter counter;

    public CounterHandler(RemoteCacheManager cacheManager, Sequence sequence) {
        CounterManager counterManager = RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)cacheManager);
        this.counterName = sequence.getExportIdentifier();
        if (!counterManager.isDefined(this.counterName)) {
            this.defineCounter(counterManager, this.counterName, sequence.getInitialValue());
        }
        this.counter = counterManager.getStrongCounter(this.counterName);
    }

    public Number nextValue(NextValueRequest request) {
        try {
            Long newValue = (Long)this.counter.addAndGet((long)request.getIncrement()).get();
            return newValue - (long)request.getIncrement();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HibernateException("Interrupting Operation " + e.getMessage(), (Throwable)e);
        }
    }

    public String getCounterName() {
        return this.counterName;
    }

    private void defineCounter(CounterManager counterManager, String counterName, int initialValue) {
        counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue((long)initialValue).storage(Storage.PERSISTENT).build());
    }
}

