/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.cachehandler;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.ogm.datastore.infinispanremote.impl.cachehandler.HotRodCacheHandler;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.infinispan.client.hotrod.RemoteCacheManager;

public class HotRodCacheValidationHandler
implements HotRodCacheHandler {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Set<String> cacheNames;

    public HotRodCacheValidationHandler(Set<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    @Override
    public void startAndValidateCaches(RemoteCacheManager hotrodClient) {
        Set<String> failedCacheNames = this.cacheNames.stream().filter(cacheName -> hotrodClient.getCache(cacheName) == null).collect(Collectors.toSet());
        if (!failedCacheNames.isEmpty()) {
            throw log.expectedCachesNotDefined(failedCacheNames);
        }
    }

    @Override
    public Set<String> getCaches() {
        return this.cacheNames;
    }

    @Override
    public String getConfiguration(String cacheName) {
        return null;
    }
}

