/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.infinispanremote.InfinispanRemoteDialect;
import org.hibernate.ogm.datastore.infinispanremote.configuration.impl.InfinispanRemoteConfiguration;
import org.hibernate.ogm.datastore.infinispanremote.impl.HotRodClientBuilder;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtoStreamMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtobufSchemaInitializer;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtostreamAssociationMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.cachehandler.HotRodCacheCreationHandler;
import org.hibernate.ogm.datastore.infinispanremote.impl.cachehandler.HotRodCacheHandler;
import org.hibernate.ogm.datastore.infinispanremote.impl.cachehandler.HotRodCacheValidationHandler;
import org.hibernate.ogm.datastore.infinispanremote.impl.counter.HotRodSequenceCounterHandler;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.schema.SchemaDefinitions;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtoDataMapper;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamSerializerSetup;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SequenceTableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.HotRodSequenceHandler;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl.InfinispanRemoteBasedQueryParserService;
import org.hibernate.ogm.datastore.infinispanremote.schema.spi.SchemaCapture;
import org.hibernate.ogm.datastore.infinispanremote.schema.spi.SchemaOverride;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.query.spi.QueryParserService;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.protostream.DescriptorParserException;

public class InfinispanRemoteDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final String SCRIPT_CACHE_NAME = "___script_cache";
    private final OgmProtoStreamMarshaller marshaller = new OgmProtoStreamMarshaller();
    private JtaPlatform jtaPlatform;
    private InfinispanRemoteConfiguration config;
    private boolean createCachesEnabled = false;
    private String cacheConfiguration;
    private RemoteCacheManager hotrodClient;
    private RemoteCacheManager scriptManager;
    private SchemaCapture schemaCapture;
    private ServiceRegistryImplementor serviceRegistry;
    private SchemaOverride schemaOverrideService;
    private URL schemaOverrideResource;
    private Map<String, ProtoDataMapper> perCacheSchemaMappers;
    private HotRodSequenceCounterHandler sequences;
    private HotRodCacheHandler cacheHandler;
    private SchemaDefinitions sd;
    private String schemaPackageName;
    private String schemaFileName;
    private TransactionMode transactionMode;

    public Class<? extends GridDialect> getDefaultDialect() {
        return InfinispanRemoteDialect.class;
    }

    public void start() {
        this.hotrodClient = HotRodClientBuilder.builder().withConfiguration(this.config, (Marshaller)this.marshaller).withTransactionMode(this.transactionMode, this.jtaPlatform).build();
        this.scriptManager = HotRodClientBuilder.builder().withConfiguration(this.config, (Marshaller)new GenericJBossMarshaller()).build();
        this.config = null;
    }

    public void stop() {
        this.hotrodClient.stop();
    }

    public void configure(Map configurationValues) {
        this.config = new InfinispanRemoteConfiguration();
        this.config.initConfiguration(configurationValues, this.serviceRegistry);
        this.schemaCapture = this.config.getSchemaCaptureService();
        this.schemaOverrideService = this.config.getSchemaOverrideService();
        this.schemaOverrideResource = this.config.getSchemaOverrideResource();
        this.schemaPackageName = this.config.getSchemaPackageName();
        this.schemaFileName = this.config.getSchemaFileName();
        this.createCachesEnabled = this.config.isCreateCachesEnabled();
        this.cacheConfiguration = this.config.getCacheConfiguration();
        this.transactionMode = this.config.getTransactionMode();
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.jtaPlatform = (JtaPlatform)serviceRegistry.getService(JtaPlatform.class);
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return ProtobufSchemaInitializer.class;
    }

    public void registerSchemaDefinitions(SchemaDefinitions sd, Set<Sequence> sequences) {
        this.sd = sd;
        this.sd.validateSchema();
        RemoteCache<String, String> protobufCache = this.getProtobufCache();
        this.sd.deploySchema(this.schemaFileName, protobufCache, this.schemaCapture, this.schemaOverrideService, this.schemaOverrideResource);
        this.registerProtoFiles(this.marshaller, sd);
        this.cacheHandler = this.createCacheHandler(sd);
        this.sequences = new HotRodSequenceCounterHandler(this, this.marshaller, sd.getSequenceDefinitions(), sequences);
        for (SequenceTableDefinition std : sd.getSequenceDefinitions().values()) {
            ProtostreamSerializerSetup.registerSequenceMarshaller(std, this.marshaller);
        }
        this.startCaches(this.cacheHandler, this.hotrodClient);
        this.perCacheSchemaMappers = sd.generateSchemaMappingAdapters(this, sd, this.marshaller);
    }

    private void registerProtoFiles(OgmProtoStreamMarshaller marshaller, SchemaDefinitions sd) {
        try {
            marshaller.getSerializationContext().registerProtoFiles(sd.asFileDescriptorSource());
        }
        catch (IOException | DescriptorParserException e) {
            throw log.errorAtProtobufParsing((Exception)e);
        }
    }

    private void startCaches(HotRodCacheHandler cacheHandler, RemoteCacheManager hotrodClient) {
        try {
            cacheHandler.startAndValidateCaches(hotrodClient);
        }
        catch (HotRodClientException ex) {
            throw log.errorAtCachesStart((Exception)((Object)ex));
        }
    }

    private HotRodCacheHandler createCacheHandler(SchemaDefinitions sd) {
        if (this.createCachesEnabled) {
            return new HotRodCacheCreationHandler(this.cacheConfiguration, sd.getCacheConfigurationByName(), this.transactionMode);
        }
        return new HotRodCacheValidationHandler(sd.getCacheConfigurationByName().keySet());
    }

    private RemoteCache<String, String> getProtobufCache() {
        return this.hotrodClient.getCache("___protobuf_metadata", TransactionMode.NONE);
    }

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return InfinispanRemoteBasedQueryParserService.class;
    }

    public URL getSchemaOverrideResource() {
        return this.schemaOverrideResource;
    }

    public String getProtobufPackageName() {
        return this.schemaPackageName;
    }

    public String getSchemaFileName() {
        return this.schemaFileName;
    }

    public String getConfiguration(String cacheName) {
        return this.cacheHandler.getConfiguration(cacheName);
    }

    public Set<String> getMappedCacheNames() {
        return this.cacheHandler.getCaches();
    }

    public ProtoStreamMappingAdapter getDataMapperForCache(String cacheName) {
        return this.perCacheSchemaMappers.get(cacheName);
    }

    public ProtostreamAssociationMappingAdapter getCollectionsDataMapper(String cacheName) {
        return this.perCacheSchemaMappers.get(cacheName);
    }

    public HotRodSequenceHandler getSequenceHandler() {
        return this.sequences;
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        RemoteCache cache = this.hotrodClient.getCache(cacheName);
        if (cache == null) {
            throw log.expectedCachesNotDefined(Collections.singleton(cacheName));
        }
        return cache;
    }

    public <K, V> RemoteCache<K, V> getScriptCache() {
        return this.scriptManager.getCache(SCRIPT_CACHE_NAME);
    }

    public <K, V> RemoteCache<K, V> getScriptExecutorCache() {
        return this.scriptManager.getCache();
    }

    public RemoteCacheManager getManager() {
        return this.hotrodClient;
    }

    public String getEntityType(RemoteCache<?, ?> c) {
        return this.getProtobufPackageName() + "." + c.getName();
    }
}

