/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.utils;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtoStreamMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamId;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamPayload;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionImpl;
import org.hibernate.ogm.model.impl.EntityKeyBuilder;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.infinispan.client.hotrod.impl.transaction.TransactionalRemoteCacheImpl;

public class TransactionalRemoteCacheCounter {
    public static int count(OgmEntityPersister persister, TransactionalRemoteCacheImpl cache, ProtoStreamMappingAdapter mapper, Session currentSession) {
        if (cache.getTransactionManager() == null) {
            return cache.size();
        }
        HashSet committedKeys = new HashSet();
        cache.keySet().forEach(committedKey -> {
            Boolean stillPresentInLocalTransaction = (Boolean)mapper.withinCacheEncodingContext(c -> c.containsKey(committedKey));
            if (stillPresentInLocalTransaction.booleanValue()) {
                committedKeys.add(committedKey);
            }
        });
        int counter = committedKeys.size();
        OgmSessionImpl ogmSession = (OgmSessionImpl)currentSession;
        PersistenceContext persistenceContext = ogmSession.getPersistenceContext();
        for (Object key : persistenceContext.getEntitiesByKey().keySet()) {
            ProtostreamId entryKey;
            org.hibernate.engine.spi.EntityKey entityKey = (org.hibernate.engine.spi.EntityKey)key;
            if (!persister.getEntityName().equals(entityKey.getEntityName()) || committedKeys.contains(entryKey = TransactionalRemoteCacheCounter.convertEntityKey(entityKey, ogmSession, mapper))) continue;
            ++counter;
        }
        return counter;
    }

    public static long countAssociations(TransactionalRemoteCacheImpl<ProtostreamId, ProtostreamPayload> cache, OgmCollectionPersister persister, Session currentSession, String[] ownerIdentifyingColumnNames) {
        HashSet<RowKey> resultsCollector = new HashSet<RowKey>();
        cache.entrySet().forEach(entry -> {
            if (cache.containsKey(entry.getKey())) {
                resultsCollector.add(TransactionalRemoteCacheCounter.convertEntityKey((ProtostreamPayload)entry.getValue(), ownerIdentifyingColumnNames));
            }
        });
        OgmSessionImpl ogmSession = (OgmSessionImpl)currentSession;
        PersistenceContext persistenceContext = ogmSession.getPersistenceContext();
        for (CollectionEntry ce : persistenceContext.getCollectionEntries().values()) {
            Object[] objectArray;
            Map snaps;
            if (!persister.getRole().equals(ce.getRole()) || !(ce.getSnapshot() instanceof Map) || (snaps = (Map)((Object)ce.getSnapshot())).isEmpty()) continue;
            Serializable loadedKey = ce.getLoadedKey();
            if (ownerIdentifyingColumnNames.length == 1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = loadedKey;
            } else {
                objectArray = (Object[])loadedKey;
            }
            Object[] columnValues = objectArray;
            resultsCollector.add(new RowKey(ownerIdentifyingColumnNames, columnValues));
        }
        return resultsCollector.size();
    }

    private static ProtostreamId convertEntityKey(org.hibernate.engine.spi.EntityKey entityKey, OgmSessionImpl ogmSession, ProtoStreamMappingAdapter mapper) {
        MetamodelImplementor metamodel = ogmSession.getFactory().getMetamodel();
        Serializable identifier = entityKey.getIdentifier();
        EntityPersister persister = metamodel.locateEntityPersister(entityKey.getEntityName());
        EntityKey ogmEntityKey = EntityKeyBuilder.fromPersister((OgmEntityPersister)((OgmEntityPersister)persister), (Serializable)identifier, (SharedSessionContractImplementor)ogmSession);
        return mapper.createIdPayload(ogmEntityKey.getColumnNames(), ogmEntityKey.getColumnValues());
    }

    private static RowKey convertEntityKey(ProtostreamPayload value, String[] columnNames) {
        Map entryObject = value.toMap();
        Object[] columnValues = new Object[columnNames.length];
        for (int i = 0; i < columnValues.length; ++i) {
            columnValues[i] = entryObject.get(columnNames[i]);
        }
        return new RowKey(columnNames, columnValues);
    }
}

