/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl;

import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;
import org.hibernate.hql.ast.spi.predicate.Predicate;

public class InfinispanRemoteQueryBuilder
implements Serializable {
    private StringBuilder builder;
    private boolean where;

    public InfinispanRemoteQueryBuilder() {
        this.builder = new StringBuilder();
    }

    public InfinispanRemoteQueryBuilder(String content) {
        this.builder = new StringBuilder(content);
    }

    public InfinispanRemoteQueryBuilder(String content, String otherContent) {
        this.builder = new StringBuilder(content);
        this.append(otherContent);
    }

    public InfinispanRemoteQueryBuilder(String content, InfinispanRemoteQueryBuilder child) {
        this.builder = new StringBuilder(content);
        this.append(child);
    }

    public InfinispanRemoteQueryBuilder(String operator, boolean negateChildren, List<Predicate<InfinispanRemoteQueryBuilder>> children) {
        this.builder = new StringBuilder("(");
        int counter = 1;
        for (Predicate<InfinispanRemoteQueryBuilder> child : children) {
            InfinispanRemoteQueryBuilder nestedQuery = negateChildren ? (InfinispanRemoteQueryBuilder)((NegatablePredicate)child).getNegatedQuery() : (InfinispanRemoteQueryBuilder)child.getQuery();
            this.builder.append(nestedQuery);
            this.builder.append(")");
            if (counter++ >= children.size()) continue;
            this.builder.append(" ");
            this.builder.append(operator);
            this.builder.append(" (");
        }
    }

    public void append(String content) {
        this.builder.append(content);
    }

    public void append(InfinispanRemoteQueryBuilder child) {
        this.builder.append((CharSequence)child.builder);
    }

    public void appendValue(Object value) {
        boolean isText = value instanceof String;
        if (isText) {
            this.builder.append("'");
        }
        this.builder.append(value);
        if (isText) {
            this.builder.append("'");
        }
    }

    public void appendValues(List<?> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.appendValue(values.get(i));
            if (i == values.size() - 1) continue;
            this.builder.append(", ");
        }
    }

    public void appendStrings(List<String> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.builder.append(values.get(i));
            if (i == values.size() - 1) continue;
            this.builder.append(", ");
        }
    }

    public void addWhere(InfinispanRemoteQueryBuilder subQuery) {
        if (this.where) {
            throw new HibernateException("Impossible to add a where clause twice in the same query");
        }
        this.builder.append(" where ");
        this.builder.append(subQuery);
        this.where = true;
    }

    public String getQuery() {
        return this.builder.toString();
    }

    public boolean hasWhere() {
        return this.where;
    }

    public String toString() {
        return this.builder.toString();
    }
}

