/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.query.parsing.impl;

import java.lang.invoke.MethodHandles;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispanremote.query.impl.InfinispanRemoteQueryDescriptor;

public class InfinispanRemoteNativeQueryParser {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final Pattern PROJECTIONS_PATTERN = Pattern.compile("^\\s*select\\s+(.*?)\\s+from\\s+(.*?)", 2);
    private static final Pattern FROM_PATTERN = Pattern.compile("^\\s*(select\\s+(.*?)\\s+)?(from\\s+.*?)(\\s+where\\s*.*)?\\s*", 2);
    private final String nativeQuery;

    public InfinispanRemoteNativeQueryParser(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public InfinispanRemoteQueryDescriptor parse() {
        String fromClause = this.fromClause();
        this.validateFromClause(fromClause);
        String cacheName = this.cacheName(fromClause);
        String entityAlias = this.entityAlias(fromClause);
        String[] projections = this.projections(entityAlias);
        return new InfinispanRemoteQueryDescriptor(cacheName, this.nativeQuery, projections);
    }

    private String[] projections(String entityAlias) {
        Matcher matcher = PROJECTIONS_PATTERN.matcher(this.nativeQuery);
        if (matcher.matches()) {
            String selectClause = matcher.group(1);
            String[] split = selectClause.split("\\s*,\\s*");
            if (split.length > 1) {
                return split;
            }
            if (split.length == 1 && !split[0].equals(entityAlias)) {
                return split;
            }
        }
        return null;
    }

    private String cacheName(String fromClause) {
        String[] fromWords = fromClause.split("\\s+");
        String[] cacheFullName = fromWords[0].split("\\.");
        String cacheName = cacheFullName[cacheFullName.length - 1];
        return cacheName;
    }

    private String entityAlias(String fromClause) {
        String[] fromWords = fromClause.split("\\s+");
        if (fromWords.length > 1) {
            return fromWords[1];
        }
        return null;
    }

    private String fromClause() {
        Matcher fromMatcher = FROM_PATTERN.matcher(this.nativeQuery);
        if (fromMatcher.matches()) {
            String clause = fromMatcher.group(3);
            return clause.substring(4).trim();
        }
        throw log.missingFromClauseInNativeQuery(this.nativeQuery);
    }

    private void validateFromClause(String clause) {
        String[] split = clause.split("\\s*,\\s*");
        if (split.length > 1) {
            throw log.multipleEntitiesInFromClause(split, this.nativeQuery);
        }
    }
}

