/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispanremote.query.impl.InfinispanRemoteQueryDescriptor;
import org.hibernate.ogm.datastore.infinispanremote.query.impl.ProtostreamPayloadClosableIterator;
import org.hibernate.ogm.datastore.infinispanremote.query.impl.RawTypeClosableIterator;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.query.spi.RowSelection;
import org.hibernate.ogm.dialect.query.spi.TypedGridValue;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;

public class InfinispanRemoteQueryHandler {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final InfinispanRemoteDatastoreProvider provider;

    public InfinispanRemoteQueryHandler(InfinispanRemoteDatastoreProvider provider) {
        this.provider = provider;
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<InfinispanRemoteQueryDescriptor> backendQuery, QueryParameters queryParameters) {
        EntityKeyMetadata entityKeyMetadata = backendQuery.getSingleEntityMetadataInformationOrNull() == null ? null : backendQuery.getSingleEntityMetadataInformationOrNull().getEntityKeyMetadata();
        InfinispanRemoteQueryDescriptor queryDescriptor = (InfinispanRemoteQueryDescriptor)backendQuery.getQuery();
        RemoteCache cache = this.provider.getCache(queryDescriptor.getCache());
        QueryFactory queryFactory = Search.getQueryFactory(cache);
        Query query = queryFactory.create(queryDescriptor.getQuery());
        this.applyNamedParameters(queryParameters, query);
        this.applyRowSelection(queryParameters, query);
        boolean hasProjection = this.hasProjection(queryDescriptor);
        if (entityKeyMetadata != null && hasProjection) {
            throw log.addEntityNotAllowedInNativeQueriesUsingProjection(entityKeyMetadata.getTable(), backendQuery.toString());
        }
        return hasProjection ? new RawTypeClosableIterator(query, queryDescriptor.getProjections()) : new ProtostreamPayloadClosableIterator(query.list());
    }

    private boolean hasProjection(InfinispanRemoteQueryDescriptor queryDescriptor) {
        return queryDescriptor.getProjections() != null && queryDescriptor.getProjections().length > 0;
    }

    private void applyNamedParameters(QueryParameters queryParameters, Query query) {
        for (Map.Entry<String, TypedGridValue> entry : queryParameters.getNamedParameters().entrySet()) {
            query.setParameter((String)entry.getKey(), this.getValue(entry));
        }
    }

    private Object getValue(Map.Entry<String, TypedGridValue> param) {
        Object value = param.getValue().getValue();
        if (value instanceof Character) {
            return value.toString();
        }
        return value;
    }

    private void applyRowSelection(QueryParameters queryParameters, Query query) {
        RowSelection rowSelection = queryParameters.getRowSelection();
        if (rowSelection == null) {
            return;
        }
        Integer firstRow = rowSelection.getFirstRow();
        Integer maxRows = rowSelection.getMaxRows();
        if (firstRow != null) {
            query.startOffset((long)firstRow.intValue());
        }
        if (maxRows != null) {
            query.maxResults(maxRows.intValue());
        }
    }
}

