/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.sequences;

import java.lang.invoke.MethodHandles;
import java.util.Random;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SequenceTableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.SequenceId;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.protostream.SerializationContext;

public final class HotRodSequencer {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final int START_EXPONENTIAL_FALLBACK = 10;
    private static final int LOG_WARNING_EACH_N_OPS = 10;
    private final RemoteCache<SequenceId, Long> remoteCache;
    private final SerializationContext serContext;
    private final OgmProtoStreamMarshaller marshaller;
    private final int increment;
    private final SequenceId id;
    private final Random random = new Random();
    private long lastKnownVersion = -1L;
    private Long lastKnownRemoteValue = null;

    HotRodSequencer(RemoteCache<SequenceId, Long> remoteCache, SequenceTableDefinition sequenceTableDefinition, NextValueRequest initialRequest, SerializationContext serContext, OgmProtoStreamMarshaller marshaller) {
        this.remoteCache = remoteCache;
        this.increment = initialRequest.getIncrement();
        this.serContext = serContext;
        this.marshaller = marshaller;
        this.id = new SequenceId(initialRequest.getKey().getColumnValue());
    }

    Number getSequenceValue(NextValueRequest request) {
        try {
            this.marshaller.setCurrentSerializationContext(this.serContext);
            Number number = this.getSequenceValueInternal(request);
            return number;
        }
        finally {
            this.marshaller.setCurrentSerializationContext(null);
        }
    }

    private synchronized Number getSequenceValueInternal(NextValueRequest request) {
        if (this.lastKnownRemoteValue == null) {
            Long initialValue = request.getInitialValue();
            Long previous = (Long)this.remoteCache.putIfAbsent((Object)this.id, (Object)initialValue);
            this.getRemoteVersion();
            if (previous == null) {
                return this.lastKnownRemoteValue;
            }
        }
        int casCycle = 0;
        Long targetValue;
        boolean done;
        while (!(done = this.attemptCASWriteValue(targetValue = Long.valueOf(this.lastKnownRemoteValue + (long)this.increment)))) {
            this.getRemoteVersion();
            if (++casCycle % 10 == 0) {
                log.excessiveCasForSequencer(this.id.getSegmentName());
            }
            if (casCycle <= 10) continue;
            this.delayRandomizerAtCycle(casCycle - 10);
        }
        return targetValue;
    }

    private void delayRandomizerAtCycle(int casCycle) {
        int exponentialMaxMilliseconds = 2 ^ casCycle;
        int nextWait = this.random.nextInt(exponentialMaxMilliseconds);
        if (nextWait == 0) {
            return;
        }
        try {
            Thread.sleep(nextWait);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.interruptedDuringCASSequenceGeneration();
        }
    }

    private boolean attemptCASWriteValue(Long targetValue) {
        boolean success = this.remoteCache.replaceWithVersion((Object)this.id, (Object)targetValue, this.lastKnownVersion);
        if (success) {
            ++this.lastKnownVersion;
            this.lastKnownRemoteValue = targetValue;
        }
        return success;
    }

    private void getRemoteVersion() {
        VersionedValue versioned = this.remoteCache.getVersioned((Object)this.id);
        if (versioned == null) {
            throw log.criticalDataLossDetected();
        }
        this.lastKnownVersion = versioned.getVersion();
        this.lastKnownRemoteValue = (Long)versioned.getValue();
    }
}

