/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.mapping.Column;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.CompositeProtobufCoDec;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldAccessorSet;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.SchemaDefinitions;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.TypeDeclarationsCollector;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtoDataMapper;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamSerializerSetup;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.ProtobufEntryExporter;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.ProtobufTypeExporter;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SanitationUtils;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.Type;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.SerializationContext;

public final class TableDefinition
implements ProtobufTypeExporter,
ProtobufEntryExporter {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final String tableName;
    private final String protobufTypeName;
    private final String protobufIdTypeName;
    private final String protobufPackageName;
    private final String cacheConfiguration;
    private final ProtofieldAccessorSet keyComponents = new ProtofieldAccessorSet();
    private final ProtofieldAccessorSet valueComponents = new ProtofieldAccessorSet();
    private final Set<String> pkColumnNames = new HashSet<String>();

    public TableDefinition(String name, String protobufPackageName, String cacheConfiguration) {
        this.tableName = name;
        this.protobufTypeName = SanitationUtils.convertNameSafely(name);
        this.protobufIdTypeName = SanitationUtils.toProtobufIdName(this.protobufTypeName);
        this.protobufPackageName = protobufPackageName;
        this.cacheConfiguration = cacheConfiguration;
    }

    public void addColumnnDefinition(Column column, GridType gridType, Type ormType) {
        String name = column.getName();
        if (this.pkColumnNames.contains(name)) {
            this.keyComponents.addMapping(name, gridType, ormType, false);
            this.valueComponents.addMapping(name, gridType, ormType, false);
        } else {
            this.valueComponents.addMapping(name, gridType, ormType, true);
        }
    }

    @Override
    public void exportProtobufEntry(StringBuilder output) {
        this.exportProtobufEntry(this.protobufIdTypeName, this.keyComponents, output);
        this.exportProtobufEntry(this.protobufTypeName, this.valueComponents, output);
    }

    private void exportProtobufEntry(String typeName, ProtofieldAccessorSet fields, StringBuilder sb) {
        sb.append("\nmessage ").append(typeName).append(" {");
        fields.forEachProtobufFieldExporter(v -> v.exportProtobufFieldDefinition(sb));
        sb.append("\n}\n");
    }

    @Override
    public void collectTypeDefinitions(TypeDeclarationsCollector typesDefCollector) {
        this.keyComponents.forEach(v -> v.collectTypeDefinitions(typesDefCollector));
        this.valueComponents.forEach(v -> v.collectTypeDefinitions(typesDefCollector));
    }

    public ProtoDataMapper createProtoDataMapper(RemoteCache remoteCache, SchemaDefinitions sd, OgmProtoStreamMarshaller marshaller) {
        try {
            CompositeProtobufCoDec codec = new CompositeProtobufCoDec(this.tableName, this.qualify(this.protobufTypeName), this.qualify(this.protobufIdTypeName), this.keyComponents, this.valueComponents, remoteCache, sd);
            SerializationContext serializationContext = ProtostreamSerializerSetup.buildSerializationContext(sd, codec, marshaller);
            return new ProtoDataMapper(codec, serializationContext, marshaller);
        }
        catch (IOException | DescriptorParserException e) {
            throw new RuntimeException(e);
        }
    }

    private String qualify(String name) {
        return SanitationUtils.qualify(name, this.protobufPackageName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void markAsPrimaryKey(String name) {
        this.pkColumnNames.add(name);
    }

    public void validate() {
        if (this.pkColumnNames.isEmpty()) {
            throw log.tableHasNoPrimaryKey(this.tableName);
        }
    }

    public String getCacheConfiguration() {
        return this.cacheConfiguration;
    }
}

