/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protobuf;

import java.lang.invoke.MethodHandles;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.BaseProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;

public final class ShortProtofieldAccessor
extends BaseProtofieldAccessor<Short>
implements ProtofieldAccessor<Short> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    public ShortProtofieldAccessor(int fieldNumber, String name, boolean nullable, String columnName) {
        super(fieldNumber, name, nullable, columnName, (outProtobuf, value) -> outProtobuf.writeInt(name, (int)value.shortValue()), reader -> {
            Integer readInt = reader.readInt(name);
            if (readInt != null) {
                int truncated = Math.min(Math.max(readInt, Short.MIN_VALUE), Short.MAX_VALUE);
                if (truncated != readInt) {
                    throw LOG.truncatingShortOnRead(readInt, name);
                }
                return (short)truncated;
            }
            return null;
        });
    }

    @Override
    protected String getProtobufTypeName() {
        return "int32";
    }
}

