/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.cachehandler;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.infinispanremote.impl.cachehandler.HotRodCacheHandler;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;

public class HotRodCacheCreationHandler
implements HotRodCacheHandler {
    public static final String OGM_BASIC_CONFIG = "<infinispan><cache-container>\t<distributed-cache-configuration name=\"configuration\">     <locking striping=\"false\" acquire-timeout=\"10000\" concurrency-level=\"50\" isolation=\"READ_COMMITTED\"/>     <transaction mode=\"NON_DURABLE_XA\" />     <expiration max-idle=\"-1\" />     <indexing index=\"NONE\" />     <state-transfer timeout=\"480000\" await-initial-transfer=\"true\" />   </distributed-cache-configuration></cache-container></infinispan>";
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Map<String, String> cacheConfigurations;
    private Set<String> failedCacheConfigurationNames = new HashSet<String>();

    public HotRodCacheCreationHandler(String globalConfiguration, Map<String, String> perCacheConfiguration) {
        this.cacheConfigurations = perCacheConfiguration;
        perCacheConfiguration.forEach((cache, configuration) -> {
            if (configuration == null) {
                perCacheConfiguration.put((String)cache, globalConfiguration);
            }
        });
    }

    @Override
    public void startAndValidateCaches(RemoteCacheManager hotrodClient) {
        this.cacheConfigurations.entrySet().forEach(entry -> {
            if (entry.getValue() == null) {
                this.startAndValidateCache(hotrodClient, (String)entry.getKey());
            } else {
                this.startAndValidateCache(hotrodClient, (String)entry.getKey(), (String)entry.getValue());
            }
        });
        if (!this.failedCacheConfigurationNames.isEmpty()) {
            throw log.expectedCacheConfiguratiosNotDefined(this.failedCacheConfigurationNames);
        }
    }

    protected void startAndValidateCache(RemoteCacheManager hotrodClient, String cacheName, String cacheConfiguration) {
        try {
            hotrodClient.administration().getOrCreateCache(cacheName, cacheConfiguration);
        }
        catch (HotRodClientException ex) {
            this.failedCacheConfigurationNames.add(cacheConfiguration);
        }
    }

    protected void startAndValidateCache(RemoteCacheManager hotrodClient, String cacheName) {
        hotrodClient.administration().getOrCreateCache(cacheName, (BasicConfiguration)new XMLStringConfiguration(OGM_BASIC_CONFIG));
    }

    @Override
    public String getConfiguration(String cacheName) {
        return this.cacheConfigurations.get(cacheName);
    }

    @Override
    public Set<String> getCaches() {
        return this.cacheConfigurations.keySet();
    }
}

