/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.SchemaDefinitions;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.TableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.options.cache.CacheConfiguration;
import org.hibernate.ogm.datastore.infinispanremote.options.cache.impl.CacheConfigurationOption;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class ProtobufSchemaInitializer
extends BaseSchemaDefiner {
    public void initializeSchema(SchemaDefiner.SchemaDefinitionContext context) {
        ServiceRegistryImplementor serviceRegistry = context.getSessionFactory().getServiceRegistry();
        TypeTranslator typeTranslator = (TypeTranslator)serviceRegistry.getService(TypeTranslator.class);
        OptionsService optionsService = (OptionsService)serviceRegistry.getService(OptionsService.class);
        Map tableEntityTypeMapping = context.getTableEntityTypeMapping();
        InfinispanRemoteDatastoreProvider datastoreProvider = (InfinispanRemoteDatastoreProvider)serviceRegistry.getService(DatastoreProvider.class);
        String protobufPackageName = datastoreProvider.getProtobufPackageName();
        SchemaDefinitions sd = new SchemaDefinitions(protobufPackageName);
        for (Namespace namespace : context.getDatabase().getNamespaces()) {
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable()) continue;
                this.createTableDefinition(context.getSessionFactory(), sd, table, typeTranslator, protobufPackageName, this.getCacheConfiguration(tableEntityTypeMapping, optionsService, table.getName()));
            }
        }
        for (IdSourceKeyMetadata iddSourceKeyMetadata : context.getAllIdSourceKeyMetadata()) {
            sd.createSequenceSchemaDefinition(iddSourceKeyMetadata, datastoreProvider.getProtobufPackageName());
        }
        datastoreProvider.registerSchemaDefinitions(sd);
    }

    private String getCacheConfiguration(Map tableEntityTypeMapping, OptionsService optionsService, String tableName) {
        Class entity = (Class)tableEntityTypeMapping.get(tableName);
        if (entity == null) {
            return null;
        }
        CacheConfiguration cacheConfiguration = (CacheConfiguration)optionsService.context().getEntityOptions(entity).getUnique(CacheConfigurationOption.class);
        if (cacheConfiguration == null) {
            return null;
        }
        return cacheConfiguration.value();
    }

    private void createTableDefinition(SessionFactoryImplementor sessionFactory, SchemaDefinitions sd, Table table, TypeTranslator typeTranslator, String protobufPackageName, String cacheConfiguration) {
        TableDefinition td = new TableDefinition(table.getName(), protobufPackageName, cacheConfiguration);
        if (table.hasPrimaryKey()) {
            for (Column pkColumn : table.getPrimaryKey().getColumns()) {
                String name = pkColumn.getName();
                td.markAsPrimaryKey(name);
            }
        }
        Iterator columnIterator = table.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column column = (Column)columnIterator.next();
            Value value = column.getValue();
            Type type = value.getType();
            if (type.isAssociationType()) {
                if ((type = type.getSemiResolvedType(sessionFactory)).isComponentType()) {
                    int index = column.getTypeIndex();
                    type = ((ComponentType)type).getSubtypes()[index];
                }
            } else if (type.isComponentType()) {
                int index = column.getTypeIndex();
                type = ((ComponentType)column.getValue().getType()).getSubtypes()[index];
            }
            GridType gridType = typeTranslator.getType(type);
            td.addColumnnDefinition(column, gridType, type);
        }
        sd.registerTableDefinition(td);
    }

    public void validateMapping(SchemaDefiner.SchemaDefinitionContext context) {
    }
}

