/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.infinispanremote.InfinispanRemoteDataStoreConfiguration;
import org.hibernate.ogm.datastore.infinispanremote.InfinispanRemoteDialect;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtoStreamMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamId;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamPayload;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.persister.impl.SingleTableOgmEntityPersister;
import org.hibernate.ogm.utils.BaseGridDialectTestHelper;
import org.hibernate.ogm.utils.GridDialectTestHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.dsl.Query;

public class InfinispanRemoteTestHelper
extends BaseGridDialectTestHelper
implements GridDialectTestHelper {
    public long getNumberOfAssociations(SessionFactory sessionFactory) {
        InfinispanRemoteDatastoreProvider datastoreProvider = InfinispanRemoteTestHelper.getProvider(sessionFactory);
        SessionFactoryImplementor sessionFactoryImplementor = InfinispanRemoteTestHelper.getSessionFactoryImplementor(sessionFactory);
        Collection persisters = sessionFactoryImplementor.getMetamodel().collectionPersisters().values();
        long totalCount = 0L;
        for (CollectionPersister ep : persisters) {
            OgmCollectionPersister persister = (OgmCollectionPersister)ep;
            String tableName = persister.getTableName();
            SingleTableOgmEntityPersister owningPersister = (SingleTableOgmEntityPersister)persister.getOwnerEntityPersister().getEntityPersister();
            String ownerTableName = owningPersister.getTableName();
            totalCount += this.countAssociations(tableName, ownerTableName, datastoreProvider);
        }
        return totalCount;
    }

    public void dropSchemaAndDatabase(SessionFactory sessionFactory) {
        InfinispanRemoteDatastoreProvider datastoreProvider = InfinispanRemoteTestHelper.getProvider(sessionFactory);
        Set mappedCacheNames = datastoreProvider.getMappedCacheNames();
        mappedCacheNames.forEach(cacheName -> datastoreProvider.getCache(cacheName).clear());
    }

    public Map<String, String> getAdditionalConfigurationProperties() {
        return Collections.singletonMap("hibernate.ogm.datastore.create_database", "true");
    }

    public long getNumberOfAssociations(SessionFactory sessionFactory, AssociationStorageType type) {
        if (type == AssociationStorageType.IN_ENTITY) {
            throw new IllegalArgumentException("IN_ENTITY association storage type not supported");
        }
        return this.getNumberOfAssociations(sessionFactory);
    }

    public GridDialect getGridDialect(DatastoreProvider datastoreProvider) {
        return new InfinispanRemoteDialect((InfinispanRemoteDatastoreProvider)datastoreProvider);
    }

    public Class<? extends DatastoreConfiguration<?>> getDatastoreConfigurationType() {
        return InfinispanRemoteDataStoreConfiguration.class;
    }

    public Map<String, Object> extractEntityTuple(Session session, EntityKey key) {
        InfinispanRemoteDatastoreProvider datastoreProvider = InfinispanRemoteTestHelper.getProvider(session);
        ProtoStreamMappingAdapter mapper = datastoreProvider.getDataMapperForCache(key.getTable());
        ProtostreamId idBuffer = mapper.createIdPayload(key.getColumnNames(), key.getColumnValues());
        ProtostreamPayload payload = (ProtostreamPayload)mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.get((Object)idBuffer));
        return payload.toMap();
    }

    private long countAssociations(String tableName, String ownerTableName, InfinispanRemoteDatastoreProvider datastoreProvider) {
        String[] ownerIdentifyingColumnNames = datastoreProvider.getDataMapperForCache(ownerTableName).listIdColumnNames();
        ProtoStreamMappingAdapter mapper = datastoreProvider.getDataMapperForCache(tableName);
        return (Long)mapper.withinCacheEncodingContext(c -> {
            Query queryAll = Search.getQueryFactory((RemoteCache)c).from(ProtostreamPayload.class).build();
            HashSet<RowKey> resultsCollector = new HashSet<RowKey>();
            try (CloseableIterator iterator = c.retrieveEntriesByQuery(queryAll, null, 100);){
                while (iterator.hasNext()) {
                    Map.Entry e = (Map.Entry)iterator.next();
                    ProtostreamPayload value = (ProtostreamPayload)e.getValue();
                    Map entryObject = value.toMap();
                    Object[] columnValues = new Object[ownerIdentifyingColumnNames.length];
                    for (int i = 0; i < columnValues.length; ++i) {
                        columnValues[i] = entryObject.get(ownerIdentifyingColumnNames[i]);
                    }
                    RowKey entryKey = new RowKey(ownerIdentifyingColumnNames, columnValues);
                    resultsCollector.add(entryKey);
                }
            }
            return resultsCollector.size();
        });
    }

    public long getNumberOfEntities(SessionFactory sessionFactory) {
        InfinispanRemoteDatastoreProvider datastoreProvider = InfinispanRemoteTestHelper.getProvider(sessionFactory);
        SessionFactoryImplementor sessionFactoryImplementor = InfinispanRemoteTestHelper.getSessionFactoryImplementor(sessionFactory);
        Collection persisters = sessionFactoryImplementor.getMetamodel().entityPersisters().values();
        AtomicLong counter = new AtomicLong();
        for (EntityPersister ep : persisters) {
            OgmEntityPersister persister = (OgmEntityPersister)ep;
            String tableName = persister.getTableName();
            int increment = datastoreProvider.getCache(tableName).size();
            counter.addAndGet(increment);
        }
        return counter.get();
    }

    private static SessionFactoryImplementor getSessionFactoryImplementor(SessionFactory sessionFactory) {
        return (SessionFactoryImplementor)sessionFactory;
    }

    public static InfinispanRemoteDatastoreProvider getProvider(Session session) {
        return InfinispanRemoteTestHelper.getProvider(session.getSessionFactory());
    }

    public static InfinispanRemoteDatastoreProvider getProvider(SessionFactory sessionFactory) {
        DatastoreProvider provider = (DatastoreProvider)((SessionFactoryImplementor)sessionFactory).getServiceRegistry().getService(DatastoreProvider.class);
        if (!InfinispanRemoteDatastoreProvider.class.isInstance(provider)) {
            throw new RuntimeException("Not testing with Infinispan Remote, cannot extract underlying cache");
        }
        return (InfinispanRemoteDatastoreProvider)InfinispanRemoteDatastoreProvider.class.cast(provider);
    }
}

